/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.NestedList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import java.util.ArrayList;
import java.util.List;

public class ParsedPage {
    private String name;
    private int pageId;
    private SectionContainer superSection = new SectionContainer(null, 0);
    private ContentElement categories;
    private ContentElement languages;
    private int firstParagraphNr;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public int getPageId() {
        return this.pageId;
    }

    public void setCategoryElement(ContentElement categories) {
        this.categories = categories;
    }

    public ContentElement getCategoryElement() {
        return this.categories;
    }

    public List<Link> getCategories() {
        if (this.categories == null) {
            return new ArrayList<Link>();
        }
        return this.categories.getLinks();
    }

    public void setFirstParagraphNr(int nr) {
        this.firstParagraphNr = nr;
    }

    public int getFirstParagraphNr() {
        return this.firstParagraphNr;
    }

    public Paragraph getFirstParagraph() {
        return this.getParagraph(this.firstParagraphNr);
    }

    public void setLanguagesElement(ContentElement languages) {
        this.languages = languages;
    }

    public ContentElement getLanguagesElement() {
        return this.languages;
    }

    public List<Link> getLanguages() {
        return this.languages.getLinks();
    }

    public void setSections(List<Section> sections) {
        for (Section s : sections) {
            this.superSection.addSection(s);
        }
    }

    public void setSections(SectionContainer s) {
        this.superSection = s;
    }

    public Section getSection(int i) {
        return this.superSection.getSubSection(i);
    }

    public List<Section> getSections() {
        return this.superSection.getSubSections();
    }

    public String toString() {
        return "ParsedPage " + this.pageId + " " + this.name;
    }

    public int nrOfParagraphs() {
        return this.superSection.nrOfParagraphs();
    }

    public Paragraph getParagraph(int i) {
        return this.superSection.getParagraph(i);
    }

    public List<Paragraph> getParagraphs() {
        return this.superSection.getParagraphs();
    }

    public int nrOfTables() {
        return this.superSection.nrOfTables();
    }

    public Table getTable(int i) {
        return this.superSection.getTable(i);
    }

    public List<Table> getTables() {
        return this.superSection.getTables();
    }

    public int nrOfNestedLists() {
        return this.superSection.nrOfNestedLists();
    }

    public NestedList getNestedList(int i) {
        return this.superSection.getNestedList(i);
    }

    public List<NestedListContainer> getNestedLists() {
        return this.superSection.getNestedLists();
    }

    public int nrOfDefinitionLists() {
        return this.superSection.nrOfDefinitionLists();
    }

    public DefinitionList getDefinitionList(int i) {
        return this.superSection.getDefinitionList(i);
    }

    public List<DefinitionList> getDefinitionLists() {
        return this.superSection.getDefinitionLists();
    }

    public String getText() {
        return this.superSection.getText();
    }

    public int length() {
        return this.superSection.length();
    }

    public List<Content.FormatType> getFormats() {
        return this.superSection.getFormats();
    }

    public List<Span> getFormatSpans(Content.FormatType t) {
        return this.superSection.getFormatSpans(t);
    }

    public List<Link> getLinks() {
        return this.superSection.getLinks();
    }

    public List<Template> getTemplates() {
        return this.superSection.getTemplates();
    }
}

