/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import java.util.ArrayList;
import java.util.List;

public class SectionContent
extends Section {
    private List<Paragraph> paragraphs;
    private List<Table> tables;
    private List<NestedListContainer> nestedLists;
    private List<DefinitionList> definitionLists;

    public SectionContent(int level) {
        super(null, level);
        this.init();
    }

    public SectionContent(ContentElement title, int level) {
        super(title, level);
        this.init();
    }

    private void init() {
        this.paragraphs = new ArrayList<Paragraph>();
        this.tables = new ArrayList<Table>();
        this.nestedLists = new ArrayList<NestedListContainer>();
        this.definitionLists = new ArrayList<DefinitionList>();
    }

    @Override
    public List<Content> getContentList() {
        return new ArrayList<Content>(this.ccl);
    }

    @Override
    public int nrOfParagraphs() {
        return this.paragraphs.size();
    }

    public void addParagraph(Paragraph p) {
        this.paragraphs.add(p);
        this.ccl.add(p);
    }

    public void removeParagraph(Paragraph p) {
        this.paragraphs.remove(p);
        this.ccl.remove(p);
    }

    @Override
    public Paragraph getParagraph(int i) {
        if (this.paragraphs.size() > i) {
            return this.paragraphs.get(i);
        }
        return null;
    }

    @Override
    public List<Paragraph> getParagraphs() {
        return new ArrayList<Paragraph>(this.paragraphs);
    }

    @Override
    public int nrOfTables() {
        return this.tables.size();
    }

    public void addTable(Table t) {
        this.tables.add(t);
        this.ccl.add(t);
    }

    public void removeTable(Table t) {
        this.tables.remove(t);
        this.ccl.remove(t);
    }

    @Override
    public Table getTable(int i) {
        if (this.tables.size() > i) {
            return this.tables.get(i);
        }
        return null;
    }

    @Override
    public List<Table> getTables() {
        return new ArrayList<Table>(this.tables);
    }

    @Override
    public int nrOfNestedLists() {
        return this.nestedLists.size();
    }

    public void addNestedList(NestedListContainer nl) {
        this.nestedLists.add(nl);
        this.ccl.add(nl);
    }

    public void removeNestedList(NestedListContainer nl) {
        this.nestedLists.remove(nl);
        this.ccl.remove(nl);
    }

    @Override
    public NestedListContainer getNestedList(int i) {
        if (this.nestedLists.size() > i) {
            return this.nestedLists.get(i);
        }
        return null;
    }

    @Override
    public List<NestedListContainer> getNestedLists() {
        return new ArrayList<NestedListContainer>(this.nestedLists);
    }

    @Override
    public int nrOfDefinitionLists() {
        return this.definitionLists.size();
    }

    public void addDefinitionList(DefinitionList dl) {
        this.definitionLists.add(dl);
        this.ccl.add(dl);
    }

    public void removeDefinitionList(DefinitionList dl) {
        this.definitionLists.remove(dl);
        this.ccl.remove(dl);
    }

    @Override
    public DefinitionList getDefinitionList(int i) {
        if (this.definitionLists.size() > i) {
            return this.definitionLists.get(i);
        }
        return null;
    }

    @Override
    public List<DefinitionList> getDefinitionLists() {
        return new ArrayList<DefinitionList>(this.definitionLists);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SC_TITLE:\n" + this.getTitleElement());
        result.append("\nSC_LEVEL: " + this.getLevel());
        result.append("\nSC_PARAGRAPHS: " + this.paragraphs.size());
        for (Paragraph paragraph : this.paragraphs) {
            result.append("\nSC_PARAGRAPH:\n" + paragraph);
        }
        result.append("\nSC_TABLES: " + this.tables.size());
        for (Table table : this.tables) {
            result.append("\nSC_TABLE:\n" + table);
        }
        result.append("\nSC_NESTED_LISTS: " + this.nestedLists.size());
        for (NestedList nestedList : this.nestedLists) {
            result.append("\nSC_NESTED_LIST:\n" + nestedList);
        }
        result.append("\nSC_DEFINITON_LISTS: " + this.definitionLists.size());
        for (DefinitionList definitionList : this.definitionLists) {
            result.append("\nSC_DEFINITION_LIST:\n" + definitionList);
        }
        return result.toString();
    }
}

