/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ContentContainer;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedList;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.TableElement;
import java.util.ArrayList;
import java.util.List;

public class Table
extends ContentContainer {
    private List<TableElement> tableElements;
    private ContentElement title;

    public Table() {
        this.ccl = new ArrayList();
        this.tableElements = new ArrayList<TableElement>();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("TB_TableElements: " + this.tableElements.size());
        for (TableElement td : this.tableElements) {
            result.append("\n" + td);
        }
        return result.toString();
    }

    public void addTableElement(TableElement te) {
        this.tableElements.add(te);
        this.ccl.add(te);
    }

    public void removeTableElement(TableElement te) {
        this.tableElements.remove(te);
        this.ccl.remove(te);
    }

    public TableElement getTableElement(int i) {
        return this.tableElements.get(i);
    }

    public ContentElement getTitleElement() {
        return this.title;
    }

    public void setTitleElement(ContentElement title) {
        if (title != null) {
            if (this.title == null) {
                this.ccl.add(0, title);
            } else {
                this.ccl.set(0, title);
            }
        } else if (this.title != null) {
            this.ccl.remove(this.title);
        }
        this.title = title;
    }

    public int nrOfTableElements() {
        return this.tableElements.size();
    }

    public List<Content> getContentList() {
        return new ArrayList<Content>(this.ccl);
    }

    public int nrOfParagraphs() {
        int result = 0;
        for (TableElement td : this.tableElements) {
            result += td.nrOfParagraphs();
        }
        return result;
    }

    public Paragraph getParagraph(int i) {
        int nr = 0;
        int offset = 0;
        for (TableElement td : this.tableElements) {
            nr = td.nrOfParagraphs();
            if (nr + offset > i) {
                return td.getParagraph(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    public List<Paragraph> getParagraphs() {
        ArrayList<Paragraph> result = new ArrayList<Paragraph>();
        for (TableElement td : this.tableElements) {
            result.addAll(td.getParagraphs());
        }
        return result;
    }

    public int nrOfTables() {
        int result = 0;
        for (TableElement td : this.tableElements) {
            result += td.nrOfTables();
        }
        return result;
    }

    public Table getTable(int i) {
        int nr = 0;
        int offset = 0;
        for (TableElement td : this.tableElements) {
            nr = td.nrOfTables();
            if (nr + offset > i) {
                return td.getTable(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    public List<Table> getTables() {
        ArrayList<Table> result = new ArrayList<Table>();
        for (TableElement td : this.tableElements) {
            result.addAll(td.getTables());
        }
        return result;
    }

    public int nrOfNestedLists() {
        int result = 0;
        for (TableElement td : this.tableElements) {
            result += td.nrOfNestedLists();
        }
        return result;
    }

    public NestedList getNestedList(int i) {
        int nr = 0;
        int offset = 0;
        for (TableElement td : this.tableElements) {
            nr = td.nrOfNestedLists();
            if (nr + offset > i) {
                return td.getNestedList(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    public List<NestedList> getNestedLists() {
        ArrayList<NestedList> result = new ArrayList<NestedList>();
        for (TableElement td : this.tableElements) {
            result.addAll(td.getNestedLists());
        }
        return result;
    }

    public int nrOfDefinitionLists() {
        int result = 0;
        for (TableElement td : this.tableElements) {
            result += td.nrOfDefinitionLists();
        }
        return result;
    }

    public DefinitionList getDefinitionList(int i) {
        int nr = 0;
        int offset = 0;
        for (TableElement td : this.tableElements) {
            nr = td.nrOfDefinitionLists();
            if (nr + offset > i) {
                return td.getDefinitionList(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    public List<DefinitionList> getDefinitionLists() {
        ArrayList<DefinitionList> result = new ArrayList<DefinitionList>();
        for (TableElement td : this.tableElements) {
            result.addAll(td.getDefinitionLists());
        }
        return result;
    }
}

