/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.mediawiki;

import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiContentElementParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiTemplateParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.ResolvedTemplate;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GermanTemplateParser
implements MediaWikiTemplateParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String templatePrefix = "TEMPLATE[";
    private final String templatePostfix = "]";
    private final String parameterDivisor = ", ";
    private final String templateNotImplementedPrefix = "TEMPLATE NOT IMPLEMENTED[";
    private final String templateNotImplementedPostfix = "]";
    private final String emptyLinkText = "[ ]";
    private List<String> deleteTemplates;
    private List<String> parseTemplates;

    public GermanTemplateParser(MediaWikiContentElementParser parser, List<String> deleteTemplates, List<String> parseTemplates) {
        this.deleteTemplates = deleteTemplates;
        this.parseTemplates = parseTemplates;
    }

    @Override
    public String configurationInfo() {
        StringBuilder result = new StringBuilder();
        result.append("Standard Template treatment: ShowNameAndParameters");
        result.append("\nDelete Templates: ");
        for (String s : this.deleteTemplates) {
            result.append("\"" + s + "\" ");
        }
        result.append("\nParse Templates: ");
        for (String s : this.parseTemplates) {
            result.append("\"" + s + "\" ");
        }
        return result.toString();
    }

    @Override
    public ResolvedTemplate parseTemplate(Template t, ParsedPage pp) {
        String templateName = t.getName();
        ResolvedTemplate result = new ResolvedTemplate(t);
        result.setPreParseReplacement("(TEMPLATE)");
        StringBuilder sb = new StringBuilder();
        sb.append("TEMPLATE[");
        sb.append(t.getName() + ", ");
        for (String s : t.getParameters()) {
            sb.append(s + ", ");
        }
        sb.delete(sb.length() - ", ".length(), sb.length());
        sb.append("]");
        result.setPostParseReplacement(sb.toString());
        result.setParsedObject(t);
        for (String s : this.deleteTemplates) {
            if (!s.equals(templateName)) continue;
            result.setPostParseReplacement("");
            result.setParsedObject(null);
            return result;
        }
        for (String s : this.parseTemplates) {
            List<String> templateParameters = t.getParameters();
            if (!s.equals(templateName)) continue;
            this.logger.info((Object)("ParseTemplate: " + templateName));
            if (templateName.equals("Dieser Artikel")) {
                result.setPostParseReplacement("");
                result.setParsedObject(null);
                return result;
            }
            if (templateName.equals("Audio") || templateName.equals("Audio genau")) {
                if (templateParameters.size() == 0) break;
                if (templateParameters.size() == 1) {
                    templateParameters.add("[ ]");
                }
                result.setPostParseReplacement(t.getParameters().get(1));
                result.setParsedObject(new Link(null, t.getPos(), templateParameters.get(0), Link.type.AUDIO, null));
                return result;
            }
            if (templateName.equals("Video")) {
                if (templateParameters.size() == 0) break;
                if (templateParameters.size() == 1) {
                    templateParameters.add("[ ]");
                }
                result.setPostParseReplacement(t.getParameters().get(1));
                result.setParsedObject(new Link(null, t.getPos(), t.getParameters().get(0), Link.type.VIDEO, null));
                return result;
            }
            result.setPostParseReplacement("TEMPLATE NOT IMPLEMENTED[" + templateName + "]");
            return result;
        }
        return result;
    }
}

