/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.mediawiki;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListElement;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContainer;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContent;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import de.tudarmstadt.ukp.wikipedia.parser.SrcSpan;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import de.tudarmstadt.ukp.wikipedia.parser.TableElement;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.EmptyStructureRemover;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiContentElementParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiTemplateParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.ResolvedTemplate;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.SpanManager;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.SrcPosRangeChecker;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModularParser
implements MediaWikiParser,
MediaWikiContentElementParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String lineSeparator;
    private List<String> categoryIdentifers;
    private List<String> languageIdentifers;
    private List<String> imageIdentifers;
    private MediaWikiTemplateParser templateParser;
    private boolean showImageText = false;
    private boolean deleteTags = true;
    private boolean showMathTagContent = true;
    private boolean calculateSrcSpans = true;

    public ModularParser() {
    }

    public ModularParser(String lineSeparator, List<String> languageIdentifers, List<String> categoryIdentifers, List<String> imageIdentifers, boolean showImageText, boolean deleteTags, boolean showMathTagContent, boolean calculateSrcSpans, MediaWikiTemplateParser templateParser) {
        this.setLineSeparator(lineSeparator);
        this.setLanguageIdentifers(languageIdentifers);
        this.setCategoryIdentifers(categoryIdentifers);
        this.setImageIdentifers(imageIdentifers);
        this.setShowImageText(showImageText);
        this.setDeleteTags(deleteTags);
        this.setShowMathTagContent(showMathTagContent);
        this.setCalculateSrcSpans(calculateSrcSpans);
        this.setTemplateParser(templateParser);
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public List<String> getLanguageIdentifers() {
        return this.languageIdentifers;
    }

    public void setLanguageIdentifers(List<String> languageIdentifers) {
        this.languageIdentifers = this.listToLowerCase(languageIdentifers);
    }

    public List<String> getCategoryIdentifers() {
        return this.categoryIdentifers;
    }

    public void setCategoryIdentifers(List<String> categoryIdentifers) {
        this.categoryIdentifers = this.listToLowerCase(categoryIdentifers);
    }

    public List<String> getImageIdentifers() {
        return this.imageIdentifers;
    }

    public void setImageIdentifers(List<String> imageIdentifers) {
        this.imageIdentifers = this.listToLowerCase(imageIdentifers);
    }

    public MediaWikiTemplateParser getTemplateParser() {
        return this.templateParser;
    }

    public void setTemplateParser(MediaWikiTemplateParser templateParser) {
        this.templateParser = templateParser;
    }

    public boolean showImageText() {
        return this.showImageText;
    }

    public void setShowImageText(boolean showImageText) {
        this.showImageText = showImageText;
    }

    public boolean deleteTags() {
        return this.deleteTags;
    }

    public void setDeleteTags(boolean deleteTags) {
        this.deleteTags = deleteTags;
    }

    public boolean showMathTagContent() {
        return this.showMathTagContent;
    }

    public void setShowMathTagContent(boolean showMathTagContent) {
        this.showMathTagContent = showMathTagContent;
    }

    public boolean calculateSrcSpans() {
        return this.calculateSrcSpans;
    }

    public void setCalculateSrcSpans(boolean calculateSrcSpans) {
        this.calculateSrcSpans = calculateSrcSpans;
    }

    private List<String> listToLowerCase(List<String> l) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : l) {
            result.add(s.toLowerCase());
        }
        return result;
    }

    @Override
    public String configurationInfo() {
        StringBuilder result = new StringBuilder();
        result.append("MediaWikiParser configuration:\n");
        result.append("ParserClass: " + this.getClass() + "\n");
        result.append("ShowImageText: " + this.showImageText + "\n");
        result.append("DeleteTags: " + this.deleteTags + "\n");
        result.append("ShowMathTagContent: " + this.showMathTagContent + "\n");
        result.append("CalculateSrcSpans: " + this.calculateSrcSpans + "\n");
        result.append("LanguageIdentifers: ");
        for (String s : this.languageIdentifers) {
            result.append(s + " ");
        }
        result.append("\n");
        result.append("CategoryIdentifers: ");
        for (String s : this.categoryIdentifers) {
            result.append(s + " ");
        }
        result.append("\n");
        result.append("ImageIdentifers: ");
        for (String s : this.imageIdentifers) {
            result.append(s + " ");
        }
        result.append("\n");
        result.append("TemplateParser: " + this.templateParser.getClass() + "\n");
        result.append(this.templateParser.configurationInfo());
        return result.toString();
    }

    private boolean runConfig() {
        if (this.lineSeparator == null) {
            this.logger.error((Object)"Set lineSeparator");
            return false;
        }
        if (this.categoryIdentifers == null) {
            this.logger.error((Object)"Set categoryIdentifers");
            return false;
        }
        if (this.languageIdentifers == null) {
            this.logger.error((Object)"Set languageIdentifers");
            return false;
        }
        if (this.imageIdentifers == null) {
            this.logger.error((Object)"Set imageIdentifers");
            return false;
        }
        if (this.templateParser == null) {
            this.logger.error((Object)"Set templateParser");
            return false;
        }
        return true;
    }

    @Override
    public ParsedPage parse(String src) {
        if (!this.runConfig()) {
            return null;
        }
        if (src == null || src.length() == 0) {
            return null;
        }
        SpanManager sm = new SpanManager(src.replace('\t', ' ') + this.lineSeparator);
        if (this.calculateSrcSpans) {
            sm.enableSrcPosCalculation();
        }
        ParsedPage ppResult = new ParsedPage();
        ContentElementParsingParameters cepp = new ContentElementParsingParameters();
        this.deleteComments(sm);
        this.deleteTOCTag(sm);
        sm.manageList(cepp.noWikiSpans);
        this.parseSpecifiedTag(sm, cepp.noWikiSpans, cepp.noWikiStrings, "PRE", " ");
        this.parseSpecifiedTag(sm, cepp.noWikiSpans, cepp.noWikiStrings, "NOWIKI");
        if (cepp.noWikiSpans.size() == 0) {
            sm.removeManagedList(cepp.noWikiSpans);
        }
        sm.manageList(cepp.mathSpans);
        this.parseSpecifiedTag(sm, cepp.mathSpans, cepp.mathStrings, "MATH");
        if (cepp.mathSpans.size() == 0) {
            sm.removeManagedList(cepp.mathSpans);
        }
        this.parseTemplates(sm, cepp.templateSpans, cepp.templates, ppResult);
        this.parseTags(sm, cepp.tagSpans);
        this.convertGalleriesToImages(sm, cepp.tagSpans);
        this.parseImagesAndInternalLinks(sm, cepp.linkSpans, cepp.links);
        LinkedList<Span> lineSpans = new LinkedList<Span>();
        this.getLineSpans(sm, lineSpans);
        ppResult.setCategoryElement(this.getSpecialLinks(sm, cepp.linkSpans, cepp.links, " - ", this.categoryIdentifers));
        ppResult.setLanguagesElement(this.getSpecialLinks(sm, cepp.linkSpans, cepp.links, " - ", this.languageIdentifers));
        ppResult.setSections(EmptyStructureRemover.eliminateEmptyStructures(this.parseSections(sm, cepp, lineSpans)));
        this.setFirstParagraph(ppResult);
        if (this.calculateSrcSpans) {
            SrcPosRangeChecker.checkRange(ppResult);
        }
        return ppResult;
    }

    private void deleteComments(SpanManager sm) {
        int start = 0;
        while ((start = sm.indexOf("<!--", start)) != -1) {
            int end = sm.indexOf("-->", start + 4) + 3;
            if (end == 2) {
                end = sm.length();
            }
            try {
                if (this.lineSeparator.equals(sm.substring(start - this.lineSeparator.length(), start)) && this.lineSeparator.equals(sm.substring(end, end + this.lineSeparator.length()))) {
                    end += this.lineSeparator.length();
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            sm.delete(start, end);
        }
    }

    private void deleteTOCTag(SpanManager sm) {
        int temp = 0;
        while ((temp = sm.indexOf("__TOC__", temp)) != -1) {
            sm.delete(temp, temp + 2 + 3 + 2);
        }
        temp = 0;
        while ((temp = sm.indexOf("__NOTOC__", temp)) != -1) {
            sm.delete(temp, temp + 2 + 5 + 2);
        }
    }

    private ContentElement getSpecialLinks(SpanManager sm, List<Span> linkSpans, List<Link> links, String linkSpacer, List<String> identifers) {
        ContentElement result = new ContentElement();
        StringBuilder text = new StringBuilder();
        ArrayList<Link> localLinks = new ArrayList<Link>();
        for (int i = links.size() - 1; i >= 0; --i) {
            String identifer = ModularParser.getLinkNameSpace(links.get(i).getTarget());
            if (identifer == null || identifers.indexOf(identifer) == -1) continue;
            Link l = links.remove(i);
            Span s = linkSpans.remove(i);
            String linkText = sm.substring(s);
            sm.delete(s);
            l.setHomeElement(result);
            s.adjust(-s.getStart() + text.length());
            text.append(linkText + linkSpacer);
            localLinks.add(l);
        }
        int len = text.length();
        if (len != 0) {
            text.delete(len - linkSpacer.length(), len);
        }
        result.setText(text.toString());
        result.setLinks(localLinks);
        if (result.empty()) {
            return null;
        }
        return result;
    }

    private void getLineSpans(SpanManager sm, LinkedList<Span> lineSpans) {
        int end;
        sm.manageList(lineSpans);
        int start = 0;
        while ((end = sm.indexOf(this.lineSeparator, start)) != -1) {
            lineSpans.add(new Span(start, end).trimTrail(sm));
            start = end + this.lineSeparator.length();
        }
        lineSpans.add(new Span(start, sm.length()).trimTrail(sm));
        while (!lineSpans.isEmpty() && lineSpans.getFirst().length() == 0) {
            lineSpans.removeFirst();
        }
        while (!lineSpans.isEmpty() && lineSpans.getLast().length() == 0) {
            lineSpans.removeLast();
        }
    }

    private SectionContainer parseSections(SpanManager sm, ContentElementParsingParameters cepp, LinkedList<Span> lineSpans) {
        ArrayList<SectionContent> contentSections = new ArrayList<SectionContent>();
        SectionContent sc = new SectionContent(1);
        if (this.calculateSrcSpans) {
            sc.setSrcSpan(new SrcSpan(sm.getSrcPos(lineSpans.getFirst().getStart()), -1));
        }
        block9: while (!lineSpans.isEmpty()) {
            Span s = lineSpans.getFirst();
            lineType t = this.getLineType(sm, s);
            switch (t) {
                case SECTION: {
                    contentSections.add(sc);
                    int level = this.getSectionLevel(sm, s);
                    sc = new SectionContent(this.parseContentElement(sm, cepp, new Span(s.getStart() + level, s.getEnd() - level).trim(sm)), level);
                    lineSpans.removeFirst();
                    if (!this.calculateSrcSpans) continue block9;
                    sc.setSrcSpan(new SrcSpan(sm.getSrcPos(s.getStart()), -1));
                    continue block9;
                }
                case HR: {
                    this.removeHr(sm, s);
                    t = lineType.PARAGRAPH;
                }
                case PARAGRAPH: 
                case PARAGRAPH_BOXED: 
                case PARAGRAPH_INDENTED: {
                    sc.addParagraph(this.buildParagraph(sm, cepp, lineSpans, t));
                    continue block9;
                }
                case NESTEDLIST: 
                case NESTEDLIST_NR: {
                    sc.addNestedList(this.buildNestedList(sm, cepp, lineSpans, t));
                    continue block9;
                }
                case DEFINITIONLIST: {
                    sc.addDefinitionList(this.buildDefinitionList(sm, cepp, lineSpans));
                    continue block9;
                }
                case TABLE: {
                    sc.addTable(this.buildTable(sm, cepp, lineSpans));
                    continue block9;
                }
                case EMPTYLINE: {
                    lineSpans.removeFirst();
                    continue block9;
                }
            }
            this.logger.error((Object)("unknown lineStart!: \"" + sm.substring(s) + "\""));
            lineSpans.removeFirst();
        }
        contentSections.add(sc);
        return this.buildSectionStructure(contentSections);
    }

    private Span removeHr(SpanManager sm, Span s) {
        int start;
        int end = s.getEnd();
        for (start = s.getStart(); sm.charAt(start) == '-' && start < end; ++start) {
        }
        return s.setStart(start).trim(sm);
    }

    private lineType getLineType(SpanManager sm, Span lineSpan) {
        switch (lineSpan.charAt(0, sm)) {
            case '{': {
                if (lineSpan.charAt(1, sm) == '|') {
                    return lineType.TABLE;
                }
                return lineType.PARAGRAPH;
            }
            case '=': {
                if (lineSpan.length() > 2 && sm.charAt(lineSpan.getEnd() - 1) == '=') {
                    return lineType.SECTION;
                }
                return lineType.PARAGRAPH;
            }
            case '-': {
                if (lineSpan.charAt(1, sm) == '-' && lineSpan.charAt(2, sm) == '-' && lineSpan.charAt(3, sm) == '-') {
                    return lineType.HR;
                }
                return lineType.PARAGRAPH;
            }
            case '*': {
                return lineType.NESTEDLIST;
            }
            case '#': {
                return lineType.NESTEDLIST_NR;
            }
            case ';': {
                return lineType.DEFINITIONLIST;
            }
            case ':': {
                if (lineSpan.length() > 1) {
                    if (lineSpan.length() > 2 && lineSpan.charAt(1, sm) == '{' && lineSpan.charAt(2, sm) == '|') {
                        return lineType.TABLE;
                    }
                    return lineType.PARAGRAPH_INDENTED;
                }
                return lineType.PARAGRAPH;
            }
            case ' ': {
                int nonWSPos = lineSpan.nonWSCharPos(sm);
                switch (lineSpan.charAt(nonWSPos, sm)) {
                    case '\u0000': {
                        return lineType.EMPTYLINE;
                    }
                    case '{': {
                        if (lineSpan.charAt(nonWSPos + 1, sm) != '|') break;
                        return lineType.TABLE;
                    }
                }
                return lineType.PARAGRAPH_BOXED;
            }
            case '\u0000': {
                return lineType.EMPTYLINE;
            }
        }
        return lineType.PARAGRAPH;
    }

    private int getSectionLevel(SpanManager sm, Span sectionNameSpan) {
        int begin = sectionNameSpan.getStart();
        int end = sectionNameSpan.getEnd();
        int level = 0;
        try {
            while (sm.charAt(begin + level) == '=' && sm.charAt(end - 1 - level) == '=') {
                ++level;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.logger.debug((Object)("EXCEPTION IS OK: " + e));
        }
        if (begin + level == end) {
            level = (level - 1) / 2;
        }
        return level;
    }

    private SectionContainer buildSectionStructure(List<SectionContent> scl) {
        SectionContainer result = new SectionContainer(0);
        for (SectionContent sContent : scl) {
            int contentLevel = sContent.getLevel();
            SectionContainer sContainer = result;
            for (int containerLevel = result.getLevel() + 1; containerLevel < contentLevel; ++containerLevel) {
                int containerSubSections = sContainer.nrOfSubSections();
                if (containerSubSections != 0) {
                    Section temp = sContainer.getSubSection(containerSubSections - 1);
                    if (temp.getClass() == SectionContainer.class) {
                        sContainer = (SectionContainer)temp;
                        continue;
                    }
                    SectionContainer sct = new SectionContainer(temp.getTitleElement(), containerLevel);
                    sct.addSection(temp);
                    if (this.calculateSrcSpans) {
                        sct.setSrcSpan(temp.getSrcSpan());
                    }
                    temp.setTitleElement(null);
                    temp.setLevel(containerLevel + 1);
                    sContainer.removeSection(temp);
                    sContainer.addSection(sct);
                    sContainer = sct;
                    continue;
                }
                sContainer = new SectionContainer(null, containerLevel);
            }
            sContainer.addSection(sContent);
        }
        if (this.calculateSrcSpans) {
            result.setSrcSpan(new SrcSpan(0, -1));
        }
        return result;
    }

    private boolean startsWithIgnoreCase(String s1, String s2) {
        int s2len = s2.length();
        if (s1.length() < s2len) {
            return false;
        }
        return s1.substring(0, s2len).equalsIgnoreCase(s2);
    }

    private Span getTag(SpanManager sm, int offset) {
        int start = sm.indexOf("<", offset);
        if (start == -1) {
            return null;
        }
        int end = sm.indexOf(">", start);
        if (end == -1) {
            return null;
        }
        Span s = new Span(start, end + 1);
        if (this.calculateSrcSpans) {
            s.setSrcSpan(new SrcSpan(sm.getSrcPos(start), sm.getSrcPos(end) + 1));
        }
        return s;
    }

    private String getTagText(SpanManager sm, Span tag) {
        return sm.substring(new Span(tag.getStart() + 1, tag.getEnd() - 1).trim(sm));
    }

    private void parseSpecifiedTag(SpanManager sm, List<Span> spans, List<String> strings, String specifier) {
        this.parseSpecifiedTag(sm, spans, strings, specifier, "");
    }

    private void parseSpecifiedTag(SpanManager sm, List<Span> spans, List<String> strings, String specifier, String prefix) {
        Span s;
        int offset = 0;
        while ((s = this.getTag(sm, offset)) != null) {
            Span e;
            offset = s.getEnd();
            String tagText = this.getTagText(sm, s);
            if (!this.startsWithIgnoreCase(tagText, specifier)) continue;
            while ((e = this.getTag(sm, offset)) != null) {
                offset = e.getEnd();
                tagText = this.getTagText(sm, e);
                if (!this.startsWithIgnoreCase(tagText, "/" + specifier)) continue;
            }
            if (e == null) {
                e = new Span(Math.max(0, sm.length() - 1), Math.max(0, sm.length() - 1));
            }
            strings.add(sm.substring(s.getEnd(), e.getStart()));
            Span tSpan = new Span(s.getStart(), e.getEnd());
            if (this.calculateSrcSpans) {
                tSpan.setSrcSpan(new SrcSpan(sm.getSrcPos(s.getStart()), sm.getSrcPos(e.getEnd())));
            }
            spans.add(tSpan);
            sm.replace(tSpan, prefix + "(" + specifier + ")");
            tSpan.adjustStart(prefix.length());
            offset = tSpan.getEnd();
        }
    }

    private void parseTags(SpanManager sm, List<Span> spans) {
        sm.manageList(spans);
        Span s = new Span(0, 0);
        while ((s = this.getTag(sm, s.getEnd())) != null) {
            spans.add(s);
        }
        if (spans.size() == 0) {
            sm.removeManagedList(spans);
        }
    }

    private void parseTemplates(SpanManager sm, List<Span> resolvedTemplateSpans, List<ResolvedTemplate> resolvedTemplates, ParsedPage pp) {
        sm.manageList(resolvedTemplateSpans);
        int pos = -2;
        Stack<Integer> templateOpenTags = new Stack<Integer>();
        while ((pos = sm.indexOf("{{", pos + 2)) != -1) {
            if (sm.length() > pos + 3 && sm.charAt(pos + 2) == '{' && sm.charAt(pos + 3) != '{') {
                ++pos;
            }
            templateOpenTags.push(pos);
        }
        while (!templateOpenTags.empty()) {
            ArrayList<String> templateOptions;
            int templateNameEnd;
            int templateOpenTag = (Integer)templateOpenTags.pop();
            int templateCloseTag = sm.indexOf("}}", templateOpenTag);
            if (templateCloseTag == -1) continue;
            int templateOptionTag = sm.indexOf("|", templateOpenTag, templateCloseTag);
            if (templateOptionTag != -1) {
                templateNameEnd = templateOptionTag;
                templateOptions = this.tokenize(sm, templateOptionTag + 1, templateCloseTag, "|");
            } else {
                templateNameEnd = templateCloseTag;
                templateOptions = new ArrayList();
            }
            Span ts = new Span(templateOpenTag, templateCloseTag + 2);
            Template t = new Template(ts, ModularParser.encodeWikistyle(sm.substring(templateOpenTag + 2, templateNameEnd).trim()), templateOptions);
            if (this.calculateSrcSpans) {
                t.setSrcSpan(new SrcSpan(sm.getSrcPos(templateOpenTag), sm.getSrcPos(templateCloseTag + 2)));
            }
            t.setPos(ts);
            ResolvedTemplate rt = this.templateParser.parseTemplate(t, pp);
            resolvedTemplateSpans.add(ts);
            resolvedTemplates.add(rt);
            sm.replace(ts, rt.getPreParseReplacement());
        }
        if (resolvedTemplateSpans.isEmpty()) {
            sm.removeManagedList(resolvedTemplateSpans);
        }
    }

    private void convertGalleriesToImages(SpanManager sm, List<Span> tagSpans) {
        for (int i = 0; i < tagSpans.size() - 1; ++i) {
            String openText = this.getTagText(sm, tagSpans.get(i));
            if (!this.startsWithIgnoreCase(openText, "GALLERY") || !this.startsWithIgnoreCase(this.getTagText(sm, tagSpans.get(i + 1)), "/GALLERY")) continue;
            Span startSpan = tagSpans.remove(i);
            Span endSpan = tagSpans.remove(i);
            --i;
            StringBuilder sb = new StringBuilder();
            int eqPos = openText.indexOf(61);
            if (eqPos != -1) {
                int captionStart = eqPos + 1;
                int captionEnd = openText.length();
                if (captionStart < captionEnd && openText.charAt(captionStart) == '\"' && openText.charAt(captionEnd - 1) == '\"') {
                    ++captionStart;
                    --captionEnd;
                }
                if (captionStart < captionEnd) {
                    sb.append(openText.substring(captionStart, captionEnd) + this.lineSeparator);
                }
            }
            for (String s : this.tokenize(sm, startSpan.getEnd(), endSpan.getStart(), this.lineSeparator)) {
                sb.append("[[" + s + "]]" + this.lineSeparator);
            }
            sm.replace(startSpan.getStart(), endSpan.getEnd(), sb.toString());
        }
    }

    private Table buildTable(SpanManager sm, ContentElementParsingParameters cepp, LinkedList<Span> lineSpans) {
        Table result = new Table();
        int col = -1;
        int row = 0;
        int subTables = 0;
        LinkedList<Span> tableDataSpans = new LinkedList<Span>();
        sm.manageList(tableDataSpans);
        if (this.calculateSrcSpans) {
            result.setSrcSpan(new SrcSpan(sm.getSrcPos(lineSpans.getFirst().getStart()), -1));
        }
        lineSpans.removeFirst();
        while (!lineSpans.isEmpty()) {
            Span s = lineSpans.removeFirst();
            int pos = s.nonWSCharPos(sm);
            char c0 = s.charAt(pos, sm);
            char c1 = s.charAt(pos + 1, sm);
            if (subTables == 0 && (c0 == '!' || c0 == '|')) {
                int optionTagPos;
                if (!tableDataSpans.isEmpty()) {
                    lineSpans.addFirst(s);
                    SrcSpan ei = null;
                    if (this.calculateSrcSpans) {
                        ei = new SrcSpan(sm.getSrcPos(tableDataSpans.getFirst().getStart() - 1) + 1, -1);
                    }
                    TableElement te = new TableElement(this.parseSections(sm, cepp, tableDataSpans), row, col);
                    te.setSrcSpan(ei);
                    result.addTableElement(te);
                    lineSpans.removeFirst();
                }
                ++col;
                if (c1 == '-') {
                    ++row;
                    col = -1;
                    continue;
                }
                if (c0 == '|' && c1 == '}') {
                    sm.removeManagedList(tableDataSpans);
                    if (this.calculateSrcSpans) {
                        result.getSrcSpan().setEnd(sm.getSrcPos(s.getEnd()));
                    }
                    return result;
                }
                if (c0 == '|' && c1 == '+') {
                    result.setTitleElement(this.parseContentElement(sm, cepp, new Span(s.getStart() + pos + 2, s.getEnd()).trim(sm)));
                    continue;
                }
                int multipleCols = sm.indexOf("||", s.getStart() + pos + 1, s.getEnd());
                if (multipleCols != -1) {
                    lineSpans.addFirst(new Span(multipleCols + 1, s.getEnd()));
                    s.setEnd(multipleCols);
                }
                if ((optionTagPos = sm.indexOf("|", s.getStart() + pos + 1, s.getEnd())) != -1) {
                    s.setStart(optionTagPos + 1).trim(sm);
                } else {
                    s.adjustStart(pos + 1).trim(sm);
                }
            } else if (c0 == '|' && c1 == '}') {
                --subTables;
            } else if (c0 == '{' && c1 == '|') {
                ++subTables;
            }
            tableDataSpans.addLast(s);
        }
        if (tableDataSpans.size() != 0) {
            SrcSpan ei = null;
            if (this.calculateSrcSpans) {
                ei = new SrcSpan(sm.getSrcPos(tableDataSpans.getFirst().getStart() - 1) + 1, -1);
            }
            TableElement te = new TableElement(this.parseSections(sm, cepp, tableDataSpans), row, col);
            te.setSrcSpan(ei);
            result.addTableElement(te);
        }
        sm.removeManagedList(tableDataSpans);
        if (this.calculateSrcSpans) {
            result.getSrcSpan().setEnd(-1);
        }
        return result;
    }

    private NestedListContainer buildNestedList(SpanManager sm, ContentElementParsingParameters cepp, LinkedList<Span> lineSpans, lineType listType) {
        Span s;
        boolean numbered = listType == lineType.NESTEDLIST_NR;
        NestedListContainer result = new NestedListContainer(numbered);
        if (this.calculateSrcSpans) {
            result.setSrcSpan(new SrcSpan(sm.getSrcPos(lineSpans.getFirst().getStart()), -1));
        }
        LinkedList<Span> nestedListSpans = new LinkedList<Span>();
        while (!lineSpans.isEmpty() && listType == this.getLineType(sm, s = lineSpans.getFirst())) {
            nestedListSpans.add(new Span(s.getStart() + 1, s.getEnd()).trim(sm));
            lineSpans.removeFirst();
        }
        sm.manageList(nestedListSpans);
        if (this.calculateSrcSpans) {
            result.getSrcSpan().setEnd(sm.getSrcPos(nestedListSpans.getLast().getEnd()));
        }
        while (!nestedListSpans.isEmpty()) {
            s = nestedListSpans.getFirst();
            lineType t = this.getLineType(sm, s);
            if (t == lineType.NESTEDLIST || t == lineType.NESTEDLIST_NR) {
                result.add(this.buildNestedList(sm, cepp, nestedListSpans, t));
                continue;
            }
            nestedListSpans.removeFirst();
            result.add((NestedListElement)this.parseContentElement(sm, cepp, s, (ContentElement)new NestedListElement()));
        }
        sm.removeManagedList(nestedListSpans);
        return result;
    }

    private DefinitionList buildDefinitionList(SpanManager sm, ContentElementParsingParameters cepp, LinkedList<Span> lineSpans) {
        Span ns;
        ArrayList<ContentElement> content = new ArrayList<ContentElement>();
        Span s = lineSpans.removeFirst();
        int temp = sm.indexOf(":", s);
        if (temp == -1) {
            content.add(this.parseContentElement(sm, cepp, new Span(s.getStart() + 1, s.getEnd())));
        } else {
            content.add(this.parseContentElement(sm, cepp, new Span(temp + 1, s.getEnd())));
            content.add(0, this.parseContentElement(sm, cepp, new Span(s.getStart() + 1, temp)));
        }
        while (!lineSpans.isEmpty() && sm.charAt((ns = lineSpans.getFirst()).getStart()) == ':') {
            lineSpans.removeFirst();
            content.add(this.parseContentElement(sm, cepp, new Span(ns.getStart() + 1, ns.getEnd())));
        }
        DefinitionList result = new DefinitionList(content);
        if (this.calculateSrcSpans) {
            result.setSrcSpan(new SrcSpan(sm.getSrcPos(s.getStart()), ((ContentElement)content.get(content.size() - 1)).getSrcSpan().getEnd()));
        }
        return result;
    }

    private Paragraph buildParagraph(SpanManager sm, ContentElementParsingParameters cepp, LinkedList<Span> lineSpans, lineType paragraphType) {
        LinkedList<Span> paragraphSpans = new LinkedList<Span>();
        Paragraph result = new Paragraph();
        Span s = lineSpans.removeFirst();
        paragraphSpans.add(s);
        switch (paragraphType) {
            case PARAGRAPH: {
                result.setType(Paragraph.type.NORMAL);
                while (!lineSpans.isEmpty() && paragraphType == this.getLineType(sm, lineSpans.getFirst())) {
                    paragraphSpans.add(lineSpans.removeFirst());
                }
                break;
            }
            case PARAGRAPH_BOXED: {
                lineType lt;
                result.setType(Paragraph.type.BOXED);
                while (!(lineSpans.isEmpty() || paragraphType != (lt = this.getLineType(sm, lineSpans.getFirst())) && lineType.EMPTYLINE != lt)) {
                    paragraphSpans.add(lineSpans.removeFirst());
                }
                break;
            }
            case PARAGRAPH_INDENTED: {
                result.setType(Paragraph.type.INDENTED);
                s.trim(sm.setCharAt(s.getStart(), ' '));
                break;
            }
            default: {
                return null;
            }
        }
        this.parseContentElement(sm, cepp, paragraphSpans, (ContentElement)result);
        return result;
    }

    private List<String> tokenize(SpanManager sm, int start, int end, String delim) {
        String token;
        int e;
        ArrayList<String> result = new ArrayList<String>();
        if (start > end) {
            this.logger.debug((Object)("tokenize(" + start + ", " + end + ") doesn't make sense"));
            return result;
        }
        int s = start;
        while ((e = sm.indexOf(delim, s, end)) != -1) {
            token = sm.substring(s, e).trim();
            if (token.length() > 0) {
                result.add(token);
            }
            s = e + delim.length();
        }
        token = sm.substring(s, end).trim();
        if (token.length() > 0) {
            result.add(token);
        }
        return result;
    }

    private void parseExternalLinks(SpanManager sm, Span s, String protocol, List<Span> managedList, List<Link> links, Content home_cc) {
        int extLinkTargetStart;
        Span extLinkSpan = new Span(0, s.getStart());
        while ((extLinkTargetStart = sm.indexOf(protocol, extLinkSpan.getEnd(), s.getEnd())) != -1) {
            int extLinkCloseTag;
            int extLinkOpenTag;
            if (extLinkTargetStart > s.getStart() && " [".indexOf(sm.charAt(extLinkTargetStart - 1)) == -1) {
                extLinkSpan = new Span(0, extLinkTargetStart + 1);
                continue;
            }
            int extLinkTargetEnd = extLinkTargetStart;
            while ((this.lineSeparator + " ]").indexOf(sm.charAt(extLinkTargetEnd)) == -1) {
                ++extLinkTargetEnd;
            }
            int extLinkTextStart = extLinkTargetStart;
            int extLinkTextEnd = extLinkTargetEnd;
            for (extLinkOpenTag = extLinkTargetStart - 1; extLinkOpenTag >= s.getStart() && sm.charAt(extLinkOpenTag) == ' '; --extLinkOpenTag) {
            }
            if (extLinkOpenTag >= s.getStart() && sm.charAt(extLinkOpenTag) == '[') {
                extLinkCloseTag = sm.indexOf("]", extLinkTargetEnd, s.getEnd());
                if (extLinkCloseTag != -1) {
                    extLinkTextStart = extLinkTargetEnd;
                    while (sm.charAt(extLinkTextStart) == ' ') {
                        ++extLinkTextStart;
                    }
                    if (extLinkTextStart == (extLinkTextEnd = extLinkCloseTag++)) {
                        sm.insert(extLinkTextStart, "[ ]");
                        extLinkTextEnd += 3;
                        extLinkCloseTag += 3;
                    }
                } else {
                    extLinkOpenTag = extLinkTargetStart;
                    extLinkCloseTag = extLinkTargetEnd;
                }
            } else {
                extLinkOpenTag = extLinkTargetStart;
                extLinkCloseTag = extLinkTargetEnd;
            }
            extLinkSpan = new Span(extLinkOpenTag, extLinkCloseTag);
            managedList.add(extLinkSpan);
            Link l = new Link(home_cc, extLinkSpan, sm.substring(extLinkTargetStart, extLinkTargetEnd), Link.type.EXTERNAL, null);
            links.add(l);
            if (this.calculateSrcSpans) {
                l.setSrcSpan(new SrcSpan(sm.getSrcPos(extLinkOpenTag), sm.getSrcPos(extLinkCloseTag - 1) + 1));
            }
            sm.delete(extLinkTextEnd, extLinkCloseTag);
            sm.delete(extLinkOpenTag, extLinkTextStart);
        }
    }

    private static String getLinkNameSpace(String target) {
        int pos = target.indexOf(58);
        if (pos == -1) {
            return null;
        }
        return target.substring(0, pos).replace('_', ' ').trim().toLowerCase();
    }

    private void parseImagesAndInternalLinks(SpanManager sm, List<Span> linkSpans, List<Link> links) {
        sm.manageList(linkSpans);
        int pos = -1;
        Stack<Integer> linkOpenTags = new Stack<Integer>();
        while ((pos = sm.indexOf("[[", pos + 1)) != -1) {
            linkOpenTags.push(pos);
        }
        Span lastLinkSpan = new Span(sm.length() + 1, sm.length() + 1);
        Link.type linkType = Link.type.INTERNAL;
        while (!linkOpenTags.empty()) {
            int lsinlink;
            List<String> parameters;
            String linkTarget;
            int linkTextStart;
            int linkStartTag = (Integer)linkOpenTags.pop();
            int linkEndTag = sm.indexOf("]]", linkStartTag);
            if (linkEndTag == -1) continue;
            int linkOptionTag = sm.indexOf("|", linkStartTag, linkEndTag);
            if (linkOptionTag != -1) {
                linkTextStart = linkOptionTag + 1;
                linkTarget = sm.substring(new Span(linkStartTag + 2, linkOptionTag).trim(sm));
            } else {
                linkTextStart = linkStartTag + 2;
                linkTarget = sm.substring(new Span(linkStartTag + 2, linkEndTag).trim(sm));
            }
            if (linkTarget.indexOf(this.lineSeparator) != -1) continue;
            String namespace = ModularParser.getLinkNameSpace(linkTarget = ModularParser.encodeWikistyle(linkTarget));
            if (namespace != null) {
                if (this.imageIdentifers.indexOf(namespace) != -1) {
                    if (linkOptionTag != -1) {
                        int temp;
                        while ((temp = sm.indexOf("|", linkTextStart, linkEndTag)) != -1) {
                            linkTextStart = temp + 1;
                        }
                        parameters = this.tokenize(sm, linkOptionTag + 1, linkEndTag, "|");
                        if (sm.charAt(linkEndTag + 2) == ']' && sm.indexOf("[", linkTextStart, linkEndTag) != -1) {
                            ++linkEndTag;
                        }
                    } else {
                        parameters = null;
                    }
                    linkType = Link.type.IMAGE;
                } else {
                    linkType = Link.type.UNKNOWN;
                    parameters = null;
                }
            } else {
                if (linkType == Link.type.INTERNAL && lastLinkSpan.hits(new Span(linkStartTag, linkEndTag + 2))) continue;
                parameters = null;
                linkType = Link.type.INTERNAL;
            }
            Span posSpan = new Span(linkTextStart, linkEndTag).trim(sm);
            linkSpans.add(posSpan);
            Link l = new Link(null, posSpan, linkTarget, linkType, parameters);
            links.add(l);
            if (this.calculateSrcSpans) {
                l.setSrcSpan(new SrcSpan(sm.getSrcPos(linkStartTag), sm.getSrcPos(linkEndTag + 2)));
            }
            sm.delete(posSpan.getEnd(), linkEndTag + 2);
            sm.delete(linkStartTag, posSpan.getStart());
            while ((lsinlink = sm.indexOf(this.lineSeparator, posSpan)) != -1) {
                sm.replace(lsinlink, lsinlink + this.lineSeparator.length(), " ");
            }
            lastLinkSpan = posSpan;
        }
    }

    private void parseQuotedSpans(SpanManager sm, Span s, List<Span> quotedSpans, String quotation) {
        int end;
        int qlen = quotation.length();
        int start = sm.indexOf(quotation, s.getStart(), s.getEnd());
        while (start != -1 && (end = sm.indexOf(quotation, start + qlen, s.getEnd())) != -1) {
            Span qs = new Span(start, end);
            quotedSpans.add(qs);
            if (this.calculateSrcSpans) {
                qs.setSrcSpan(new SrcSpan(sm.getSrcPos(start), sm.getSrcPos(end + qlen - 1) + 1));
            }
            sm.delete(end, end + qlen);
            sm.delete(start, start + qlen);
            start = sm.indexOf(quotation, qs.getEnd(), s.getEnd());
        }
    }

    private void parseBoldAndItalicSpans(SpanManager sm, Span line, List<Span> boldSpans, List<Span> italicSpans) {
        this.parseQuotedSpans(sm, line, boldSpans, "'''");
        this.parseQuotedSpans(sm, line, italicSpans, "''");
        int openTag = sm.indexOf("''", line);
        if (openTag != -1) {
            Span qs = new Span(openTag, line.getEnd());
            if (this.calculateSrcSpans) {
                qs.setSrcSpan(new SrcSpan(sm.getSrcPos(openTag), sm.getSrcPos(line.getEnd())));
            }
            if (sm.indexOf("'''", openTag, openTag + 3) != -1) {
                boldSpans.add(qs);
                sm.delete(openTag, openTag + 3);
            } else {
                italicSpans.add(qs);
                sm.delete(openTag, openTag + 2);
            }
        }
    }

    private static String encodeWikistyle(String str) {
        return str.replace(' ', '_');
    }

    @Override
    public ContentElement parseContentElement(String src) {
        SpanManager sm = new SpanManager(src);
        ContentElementParsingParameters cepp = new ContentElementParsingParameters();
        this.parseImagesAndInternalLinks(sm, cepp.linkSpans, cepp.links);
        LinkedList<Span> lineSpans = new LinkedList<Span>();
        this.getLineSpans(sm, lineSpans);
        sm.removeManagedList(lineSpans);
        return this.parseContentElement(sm, cepp, lineSpans, new ContentElement());
    }

    private ContentElement parseContentElement(SpanManager sm, ContentElementParsingParameters cepp, Span lineSpan) {
        LinkedList<Span> lineSpans = new LinkedList<Span>();
        lineSpans.add(lineSpan);
        return this.parseContentElement(sm, cepp, lineSpans, new ContentElement());
    }

    private ContentElement parseContentElement(SpanManager sm, ContentElementParsingParameters cepp, Span lineSpan, ContentElement result) {
        LinkedList<Span> lineSpans = new LinkedList<Span>();
        lineSpans.add(lineSpan);
        return this.parseContentElement(sm, cepp, lineSpans, result);
    }

    private ContentElement parseContentElement(SpanManager sm, ContentElementParsingParameters cepp, LinkedList<Span> lineSpans, ContentElement result) {
        ArrayList<Link> localLinks = new ArrayList<Link>();
        ArrayList<Template> localTemplates = new ArrayList<Template>();
        ArrayList<Span> boldSpans = new ArrayList<Span>();
        ArrayList<Span> italicSpans = new ArrayList<Span>();
        sm.manageList(boldSpans);
        sm.manageList(italicSpans);
        ArrayList<Span> managedSpans = new ArrayList<Span>();
        sm.manageList(managedSpans);
        Span contentElementRange = new Span(lineSpans.getFirst().getStart(), lineSpans.getLast().getEnd()).trim(sm);
        managedSpans.add(contentElementRange);
        if (this.calculateSrcSpans) {
            result.setSrcSpan(new SrcSpan(sm.getSrcPos(contentElementRange.getStart()), sm.getSrcPos(contentElementRange.getEnd())));
        }
        sm.manageList(lineSpans);
        while (!lineSpans.isEmpty()) {
            Span line = lineSpans.getFirst();
            this.parseBoldAndItalicSpans(sm, line, boldSpans, italicSpans);
            this.parseExternalLinks(sm, line, "http://", managedSpans, localLinks, result);
            this.parseExternalLinks(sm, line, "https://", managedSpans, localLinks, result);
            this.parseExternalLinks(sm, line, "ftp://", managedSpans, localLinks, result);
            this.parseExternalLinks(sm, line, "mailto:", managedSpans, localLinks, result);
            lineSpans.removeFirst();
        }
        sm.removeManagedList(lineSpans);
        int i = 0;
        while (i < cepp.linkSpans.size()) {
            if (contentElementRange.hits(cepp.linkSpans.get(i))) {
                Span linkSpan = cepp.linkSpans.remove(i);
                managedSpans.add(linkSpan);
                Link l = cepp.links.remove(i).setHomeElement(result);
                localLinks.add(l);
                if (this.showImageText || l.getType() != Link.type.IMAGE) continue;
                sm.delete(linkSpan);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < cepp.templateSpans.size()) {
            Span ts = cepp.templateSpans.get(i);
            if (contentElementRange.hits(ts)) {
                ResolvedTemplate rt = cepp.templates.remove(i);
                if (rt.getPostParseReplacement() != null) {
                    sm.replace(ts, rt.getPostParseReplacement());
                }
                cepp.templateSpans.remove(i);
                Object parsedObject = rt.getParsedObject();
                if (parsedObject == null) continue;
                managedSpans.add(ts);
                Class<?> parsedObjectClass = parsedObject.getClass();
                if (parsedObjectClass == Template.class) {
                    localTemplates.add((Template)parsedObject);
                    continue;
                }
                if (parsedObjectClass == Link.class) {
                    localLinks.add(((Link)parsedObject).setHomeElement(result));
                    continue;
                }
                localTemplates.add(rt.getTemplate());
                continue;
            }
            ++i;
        }
        i = 0;
        ArrayList<Span> tags = new ArrayList<Span>();
        while (i < cepp.tagSpans.size()) {
            Span s = cepp.tagSpans.get(i);
            if (contentElementRange.hits(s)) {
                cepp.tagSpans.remove(i);
                if (this.deleteTags) {
                    sm.delete(s);
                    continue;
                }
                tags.add(s);
                managedSpans.add(s);
                continue;
            }
            ++i;
        }
        i = 0;
        ArrayList<Span> localNoWikiSpans = new ArrayList<Span>();
        while (i < cepp.noWikiSpans.size()) {
            Span s = cepp.noWikiSpans.get(i);
            if (contentElementRange.hits(s)) {
                cepp.noWikiSpans.remove(i);
                sm.replace(s, cepp.noWikiStrings.remove(i));
                localNoWikiSpans.add(s);
                managedSpans.add(s);
                continue;
            }
            ++i;
        }
        i = 0;
        ArrayList<Span> mathSpans = new ArrayList<Span>();
        while (i < cepp.mathSpans.size()) {
            Span s = cepp.mathSpans.get(i);
            if (contentElementRange.hits(s)) {
                cepp.mathSpans.remove(i);
                if (this.showMathTagContent) {
                    mathSpans.add(s);
                    managedSpans.add(s);
                    sm.replace(s, cepp.mathStrings.remove(i));
                    continue;
                }
                sm.delete(s);
                continue;
            }
            ++i;
        }
        result.setText(sm.substring(contentElementRange));
        sm.removeManagedList(boldSpans);
        sm.removeManagedList(italicSpans);
        sm.removeManagedList(managedSpans);
        int adjust = -contentElementRange.getStart();
        for (Span s : boldSpans) {
            s.adjust(adjust);
        }
        for (Span s : italicSpans) {
            s.adjust(adjust);
        }
        for (Span s : managedSpans) {
            s.adjust(adjust);
        }
        result.setFormatSpans(Content.FormatType.BOLD, boldSpans);
        result.setFormatSpans(Content.FormatType.ITALIC, italicSpans);
        result.setFormatSpans(Content.FormatType.TAG, tags);
        result.setFormatSpans(Content.FormatType.MATH, mathSpans);
        result.setFormatSpans(Content.FormatType.NOWIKI, localNoWikiSpans);
        result.setLinks(ModularParser.sortLinks(localLinks));
        result.setTemplates(ModularParser.sortTemplates(localTemplates));
        return result;
    }

    private static List<Link> sortLinks(List<Link> links) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : links) {
            int pos;
            for (pos = 0; pos < result.size() && l.getPos().getStart() > ((Link)result.get(pos)).getPos().getStart(); ++pos) {
            }
            result.add(pos, l);
        }
        return result;
    }

    private static List<Template> sortTemplates(List<Template> templates) {
        ArrayList<Template> result = new ArrayList<Template>();
        for (Template t : templates) {
            int pos;
            for (pos = 0; pos < result.size() && t.getPos().getStart() > ((Template)result.get(pos)).getPos().getStart(); ++pos) {
            }
            result.add(pos, t);
        }
        return result;
    }

    private void setFirstParagraph(ParsedPage pp) {
        int nr = pp.nrOfParagraphs();
        for (int i = 0; i < nr; ++i) {
            int j;
            Paragraph p = pp.getParagraph(i);
            SpanManager ptext = new SpanManager(p.getText());
            ArrayList<Span> delete = new ArrayList<Span>();
            ptext.manageList(delete);
            List<Template> tl = p.getTemplates();
            for (int j2 = tl.size() - 1; j2 >= 0; --j2) {
                delete.add(tl.get(j2).getPos());
            }
            List<Span> sl = p.getFormatSpans(Content.FormatType.TAG);
            for (j = sl.size() - 1; j >= 0; --j) {
                delete.add(sl.get(j));
            }
            if (this.showImageText) {
                List<Link> ll = p.getLinks(Link.type.IMAGE);
                for (int j3 = ll.size() - 1; j3 >= 0; --j3) {
                    delete.add(ll.get(j3).getPos());
                }
            }
            for (j = delete.size() - 1; j >= 0; --j) {
                ptext.delete((Span)delete.remove(j));
            }
            int pos = ptext.indexOf(this.lineSeparator);
            while (pos != -1) {
                ptext.delete(pos, pos + this.lineSeparator.length());
                pos = ptext.indexOf(this.lineSeparator);
            }
            if (ptext.toString().trim().equals("")) continue;
            pp.setFirstParagraphNr(i);
            return;
        }
    }

    class ContentElementParsingParameters {
        List<Span> noWikiSpans = new ArrayList<Span>();
        List<String> noWikiStrings = new ArrayList<String>();
        List<Span> linkSpans = new ArrayList<Span>();
        List<Link> links = new ArrayList<Link>();
        List<Span> templateSpans = new ArrayList<Span>();
        List<ResolvedTemplate> templates = new ArrayList<ResolvedTemplate>();
        List<Span> tagSpans = new ArrayList<Span>();
        List<Span> mathSpans = new ArrayList<Span>();
        List<String> mathStrings = new ArrayList<String>();

        ContentElementParsingParameters() {
        }
    }

    private static enum lineType {
        SECTION,
        TABLE,
        NESTEDLIST,
        NESTEDLIST_NR,
        DEFINITIONLIST,
        HR,
        PARAGRAPH,
        PARAGRAPH_INDENTED,
        PARAGRAPH_BOXED,
        EMPTYLINE;

    }
}

