/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.mediawiki;

import de.tudarmstadt.ukp.wikipedia.parser.Span;
import java.util.ArrayList;
import java.util.List;

public class SpanManager
implements CharSequence {
    private final StringBuilder sb;
    private final List<List<Span>> managedLists;
    private List<Integer> ib;
    private boolean calculateSrcPositions;

    public SpanManager(String src) {
        this.sb = new StringBuilder(src);
        this.managedLists = new ArrayList<List<Span>>();
        this.calculateSrcPositions = false;
    }

    public void enableSrcPosCalculation() {
        this.calculateSrcPositions = true;
        int len = this.sb.length();
        this.ib = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            this.ib.add(i);
        }
    }

    public int getSrcPos(int index) {
        if (this.calculateSrcPositions) {
            return this.ib.get(index);
        }
        System.err.println("SrcSpanCalculation not enabled!");
        return -1;
    }

    public void manageList(List<Span> spans) {
        this.managedLists.add(spans);
    }

    public void removeManagedList(List<Span> spans) {
        Span listIdentifer = new Span(Integer.MAX_VALUE, Integer.MIN_VALUE);
        spans.add(listIdentifer);
        this.managedLists.remove(spans);
        spans.remove(listIdentifer);
    }

    private void adjustLists(int offset, int n) {
        for (List<Span> list : this.managedLists) {
            for (Span s : list) {
                s.adjust(offset, n);
            }
        }
    }

    public SpanManager delete(Span s) {
        return this.delete(s.getStart(), s.getEnd());
    }

    public SpanManager delete(int start, int end) {
        this.sb.delete(start, end);
        this.adjustLists(start, start - end);
        if (this.calculateSrcPositions) {
            for (int i = 0; i < end - start; ++i) {
                this.ib.remove(start);
            }
        }
        return this;
    }

    public SpanManager insert(int offset, String str) {
        this.sb.insert(offset, str);
        this.adjustLists(offset, str.length());
        if (this.calculateSrcPositions) {
            for (int i = 0; i < str.length(); ++i) {
                this.ib.add(offset, -1);
            }
        }
        return this;
    }

    public SpanManager replace(Span s, String str) {
        return this.replace(s.getStart(), s.getEnd(), str);
    }

    public SpanManager replace(int start, int end, String str) {
        this.sb.replace(start, end, str);
        if (this.calculateSrcPositions) {
            int i;
            for (i = 0; i < end - start; ++i) {
                this.ib.remove(start);
            }
            for (i = 0; i < str.length(); ++i) {
                this.ib.add(start, -1);
            }
        }
        this.adjustLists(start, str.length() - (end - start));
        return this;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return this.sb.indexOf(str, fromIndex);
    }

    public int indexOf(String str, Span s) {
        return this.indexOf(str, s.getStart(), s.getEnd());
    }

    public int indexOf(String str, int fromIndex, int toIndex) {
        int result = this.sb.indexOf(str, fromIndex);
        if (result >= toIndex) {
            return -1;
        }
        return result;
    }

    public String substring(int start) {
        if (start < 0) {
            start = 0;
        }
        return this.sb.substring(start);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (start > end) {
            return "";
        }
        return this.sb.substring(start, end);
    }

    public String substring(Span s) {
        if (s.getStart() < s.getEnd()) {
            return this.sb.substring(s.getStart(), s.getEnd());
        }
        return "";
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        System.err.println("CharSequence subSequence(int start, int end)\nSorry, not Implemented");
        this.sb.charAt(-1);
        return null;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    public SpanManager setCharAt(int index, char c) {
        this.sb.setCharAt(index, c);
        if (this.calculateSrcPositions) {
            this.ib.set(index, -1);
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public String info() {
        StringBuilder result = new StringBuilder();
        result.append("\n-=SPANMANAGER=----------------------------------------------------------------\n");
        result.append("TEXT:");
        result.append("\"" + this.sb.toString() + "\"");
        result.append("\n");
        result.append("\nMANAGED SPAN LISTS:");
        if (this.managedLists.isEmpty()) {
            result.append(" NONE\n");
        } else {
            result.append("\n");
            for (int k = 0; k < this.managedLists.size(); ++k) {
                List<Span> sl = this.managedLists.get(k);
                result.append("{");
                if (sl.size() != 0) {
                    for (int i = 1; i < sl.size() - 1; ++i) {
                        result.append(sl.get(i) + ", ");
                    }
                    result.append(sl.get(sl.size() - 1));
                }
                result.append("}\n");
            }
        }
        result.append("------------------------------------------------------------------------------");
        return result.toString();
    }
}

