/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.tutorial;

import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.parser.NestedList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListElement;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParserFactory;

public class T6_NestedLists {
    public static void main(String[] args) throws WikiApiException {
        DatabaseConfiguration dbConfig = new DatabaseConfiguration();
        dbConfig.setDatabase("DATABASE");
        dbConfig.setHost("HOST");
        dbConfig.setUser("USER");
        dbConfig.setPassword("PASSWORD");
        dbConfig.setLanguage(WikiConstants.Language.english);
        Wikipedia wiki = new Wikipedia(dbConfig);
        MediaWikiParserFactory pf = new MediaWikiParserFactory(WikiConstants.Language.english);
        MediaWikiParser parser = pf.createParser();
        ParsedPage pp = parser.parse(wiki.getPage("House_(disambiguation)").getText());
        int i = 1;
        for (NestedList nestedList : pp.getNestedLists()) {
            System.out.println(i + ": \n" + T6_NestedLists.outputNestedList(nestedList, 0));
            ++i;
        }
    }

    public static String outputNestedList(NestedList nl, int depth) {
        String result = "";
        if (nl == null) {
            return result;
        }
        for (int i = 0; i < depth; ++i) {
            result = result + " ";
        }
        if (nl.getClass() == NestedListElement.class) {
            result = result + nl.getText();
        } else {
            result = result + "---";
            for (NestedList nl2 : ((NestedListContainer)nl).getNestedLists()) {
                result = result + "\n" + T6_NestedLists.outputNestedList(nl2, depth + 1);
            }
        }
        return result;
    }
}

