/*
 * Decompiled with CFR 0.152.
 */
package de.tum.cit.aet.helios;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.tum.cit.aet.helios.HeliosEndpoint;
import de.tum.cit.aet.helios.HeliosStatusProperties;
import de.tum.cit.aet.helios.status.LifecycleState;
import de.tum.cit.aet.helios.status.PushStatusPayload;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.StringUtils;

public class HeliosClient
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HeliosClient.class);
    private static final MediaType JSON = MediaType.get((String)"application/json");
    private static final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), r -> {
        Thread t = new Thread(r);
        t.setName("Helios-OkHttp");
        t.setDaemon(true);
        return t;
    }, (r, ex) -> log.warn("Helios push queue is full. Dropping status update."));
    private static final OkHttpClient client = new OkHttpClient.Builder().dispatcher(new Dispatcher(executor)).connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).callTimeout(10L, TimeUnit.SECONDS).build();
    private static final ObjectMapper mapper = new ObjectMapper();
    private final HeliosStatusProperties cfg;
    private final List<HeliosEndpoint> endpoints;
    private final String environment;

    public HeliosClient(HeliosStatusProperties cfg) {
        this.cfg = cfg;
        this.environment = cfg.environmentName();
        this.endpoints = cfg.endpoints();
    }

    public void pushStartingUp() {
        this.pushStatusUpdate(LifecycleState.STARTING_UP);
    }

    public void pushRunning() {
        this.pushStatusUpdate(LifecycleState.RUNNING);
    }

    public void pushShuttingDown() {
        this.pushStatusUpdate(LifecycleState.SHUTTING_DOWN);
    }

    public void pushFailed() {
        this.pushStatusUpdate(LifecycleState.FAILED);
    }

    public void pushDbMigrationStarted() {
        this.pushStatusUpdate(LifecycleState.DB_MIGRATION_STARTED);
    }

    public void pushDbMigrationFinished() {
        this.pushStatusUpdate(LifecycleState.DB_MIGRATION_FINISHED);
    }

    public void pushDbMigrationFailed() {
        this.pushStatusUpdate(LifecycleState.DB_MIGRATION_FAILED);
    }

    public void pushDegraded() {
        this.pushStatusUpdate(LifecycleState.DEGRADED);
    }

    public void pushStopped() {
        this.pushStatusUpdate(LifecycleState.STOPPED);
    }

    public void pushStatusUpdate(LifecycleState state) {
        this.pushStatusUpdate(state, Map.of());
    }

    public void pushStatusUpdate(LifecycleState state, Map<String, Object> details) {
        if (!this.cfg.enabled()) {
            log.debug("Helios push is disabled. Skipping push.");
            return;
        }
        if (this.endpoints.isEmpty()) {
            log.warn("No Helios endpoints configured. Skipping push.");
            return;
        }
        if (this.environment == null || this.environment.isBlank()) {
            log.warn("Helios payload is missing environment. Skipping push.");
            return;
        }
        PushStatusPayload p = PushStatusPayload.of(this.environment, state, details);
        if (state == LifecycleState.DB_MIGRATION_FAILED || state == LifecycleState.FAILED || state == LifecycleState.SHUTTING_DOWN) {
            this.pushStatusUpdateSync(p);
        } else {
            this.pushStatusUpdateAsync(p);
        }
    }

    private void pushStatusUpdateAsync(final PushStatusPayload payload) {
        if (payload == null) {
            log.warn("Helios payload is null. Skipping push.");
            return;
        }
        for (int i = 0; i < this.endpoints.size(); ++i) {
            final int idx = i;
            try {
                HeliosEndpoint ep = this.endpoints.get(i);
                final String url = Objects.toString(ep.url(), "");
                String secret = Objects.toString(ep.secretKey(), "");
                if (!StringUtils.hasText((String)url) || !StringUtils.hasText((String)secret)) {
                    log.warn("Helios endpoint #{} is missing URL or secret (url='{}', secretPresent={}). Skipping.", new Object[]{i, url, StringUtils.hasText((String)secret)});
                    continue;
                }
                String json = mapper.writeValueAsString((Object)payload);
                Request request = new Request.Builder().url(ep.url().toString()).header("Authorization", "Secret " + ep.secretKey()).post(RequestBody.create((String)json, (MediaType)JSON)).build();
                client.newCall(request).enqueue(new Callback(){

                    public void onFailure(@NotNull Call call, @NotNull IOException e) {
                        log.warn("Helios push #{} to '{}' failed: {}. Payload={}", new Object[]{idx, url, e.getMessage(), payload, e});
                    }

                    public void onResponse(@NotNull Call call, @NotNull Response response) {
                        boolean isSuccess;
                        int code = response.code();
                        boolean bl = isSuccess = code >= 200 && code < 300;
                        if (isSuccess) {
                            log.debug("Helios push #{} '{}' [{}] \u2013 OK", new Object[]{idx, url, code});
                        } else {
                            log.warn("Helios push #{} '{}' responded [{} {}]. Payload={}", new Object[]{idx, url, code, response.message(), payload});
                        }
                        response.close();
                    }
                });
                continue;
            }
            catch (Exception e) {
                log.error("Failed to serialize Helios payload: {}", (Object)e.getMessage());
            }
        }
    }

    private void pushStatusUpdateSync(PushStatusPayload payload) {
        for (HeliosEndpoint ep : this.endpoints) {
            try {
                if (!StringUtils.hasText((String)String.valueOf(ep.url())) || !StringUtils.hasText((String)ep.secretKey())) {
                    log.warn("Helios endpoint '{}' missing URL/secret \u2013 skipping", (Object)ep.url());
                    continue;
                }
                Request req = new Request.Builder().url(ep.url().toString()).header("Authorization", "Secret " + ep.secretKey()).post(RequestBody.create((byte[])mapper.writeValueAsBytes((Object)payload), (MediaType)JSON)).build();
                try {
                    Response resp = client.newCall(req).execute();
                    try {
                        if (resp.isSuccessful()) {
                            log.info("Helios sync push to '{}' [{}] \u2013 OK", (Object)ep.url(), (Object)resp.code());
                            continue;
                        }
                        log.warn("Helios sync push to '{}' [{} {}] FAILED", new Object[]{ep.url(), resp.code(), resp.message()});
                    }
                    finally {
                        if (resp == null) continue;
                        resp.close();
                    }
                }
                catch (Exception ioe) {
                    log.warn("Helios sync push to '{}' failed: {}", (Object)ep.url(), (Object)ioe.getMessage());
                }
            }
            catch (Exception e) {
                log.error("Failed to serialize Helios payload: {}", (Object)e.getMessage());
            }
        }
    }

    private static void flush() {
        Dispatcher dispatcher = client.dispatcher();
        dispatcher.executorService().shutdown();
        try {
            dispatcher.executorService().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
        log.info("Destroying HeliosClient, flushing pending pushes.");
        HeliosClient.flush();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LoggerFactory.getLogger(HeliosClient.class).info("Helios shutdown-hook: flushing pending pushes");
            HeliosClient.flush();
        }, "Helios-ShutdownHook"));
    }
}

