/*
 * Decompiled with CFR 0.152.
 */
package de.tum.cit.aet.helios;

import de.tum.cit.aet.helios.HeliosEndpoint;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="helios.status")
@Validated
public record HeliosStatusProperties(boolean enabled, String environmentName, List<HeliosEndpoint> endpoints, @DurationUnit(value=ChronoUnit.SECONDS) Duration heartbeatInterval) {
    public HeliosStatusProperties {
        if (heartbeatInterval == null) {
            heartbeatInterval = Duration.ofSeconds(30L);
        }
        if (!heartbeatInterval.isPositive()) {
            throw new IllegalArgumentException("helios.status.heartbeat-interval must be positive");
        }
    }
}

