/*
 * Decompiled with CFR 0.152.
 */
package de.tum.cit.aet.helios.autoconfig;

import de.tum.cit.aet.helios.HeliosClient;
import de.tum.cit.aet.helios.status.LifecycleState;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
class BootLifecycleListener {
    private final HeliosClient helios;

    BootLifecycleListener(HeliosClient helios) {
        this.helios = helios;
    }

    @EventListener
    void onStarted(ApplicationStartedEvent e) {
        this.helios.pushStatusUpdate(LifecycleState.STARTING_UP);
    }

    @EventListener
    void onFailed(ApplicationFailedEvent e) {
        this.helios.pushStatusUpdate(LifecycleState.FAILED);
    }

    @EventListener
    void onReady(ApplicationReadyEvent e) {
        this.helios.pushStatusUpdate(LifecycleState.RUNNING);
    }

    @EventListener
    void onShutdown(ContextClosedEvent e) {
        this.helios.pushStatusUpdate(LifecycleState.SHUTTING_DOWN);
    }
}

