/*
 * Decompiled with CFR 0.152.
 */
package de.tum.cit.aet.helios.autoconfig;

import de.tum.cit.aet.helios.HeliosClient;
import de.tum.cit.aet.helios.HeliosStatusProperties;
import de.tum.cit.aet.helios.status.LifecycleState;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

@Component
class HeartbeatScheduler
implements SchedulingConfigurer {
    private final HeliosClient helios;
    private final HeliosStatusProperties props;

    HeartbeatScheduler(HeliosClient helios, HeliosStatusProperties props) {
        this.helios = helios;
        this.props = props;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        TaskScheduler scheduler = taskRegistrar.getScheduler();
        if (scheduler != null && this.props.enabled()) {
            Runnable heartbeatTask = () -> this.helios.pushStatusUpdate(LifecycleState.RUNNING);
            scheduler.scheduleWithFixedDelay(heartbeatTask, this.props.heartbeatInterval());
        }
    }
}

