/*
 * Decompiled with CFR 0.152.
 */
package de.tum.cit.aet.helios.autoconfig;

import de.tum.cit.aet.helios.HeliosClient;
import de.tum.cit.aet.helios.HeliosStatusProperties;
import de.tum.cit.aet.helios.autoconfig.BootLifecycleListener;
import de.tum.cit.aet.helios.autoconfig.HeartbeatScheduler;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={HeliosStatusProperties.class})
public class HeliosStatusAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HeliosStatusAutoConfiguration.class);
    private final HeliosStatusProperties props;

    public HeliosStatusAutoConfiguration(HeliosStatusProperties props) {
        this.props = props;
    }

    @PostConstruct
    public void logStatus() {
        if (this.props.enabled()) {
            int endpointCount = this.props.endpoints() != null ? this.props.endpoints().size() : 0;
            String env = this.props.environmentName() != null ? this.props.environmentName() : "(none)";
            log.info("Helios status push is enabled \u2013 monitoring will start for environment name '{}', pushing to {} endpoint(s).", (Object)env, (Object)endpointCount);
        } else {
            log.info("Helios status push is disabled \u2013 no lifecycle updates will be sent.");
        }
    }

    @Bean
    ApplicationRunner validateHeliosCfg(HeliosStatusProperties p) {
        return args -> {
            if (p.enabled() && (p.environmentName() == null || p.environmentName().isBlank() || p.endpoints() == null || p.endpoints().isEmpty())) {
                throw new IllegalStateException("helios.status.enabled=true but environment-name or endpoints missing.\nEach endpoint needs url + secretKey.");
            }
        };
    }

    @Bean
    HeliosClient heliosClient(HeliosStatusProperties props) {
        return new HeliosClient(props);
    }

    @Bean
    BootLifecycleListener bootLifecycleListener(HeliosClient helios) {
        return this.props.enabled() ? new BootLifecycleListener(helios) : null;
    }

    @Bean
    HeartbeatScheduler heartbeatScheduler(HeliosClient helios) {
        return this.props.enabled() ? new HeartbeatScheduler(helios, this.props) : null;
    }
}

