/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

final class ArtemisSecurityConfigurationImpl
implements ArtemisSecurityConfiguration {
    private final Class<?> testClass;
    private final Method testMethod;
    private final Path executionPath;
    private final List<String> whitelistedClassNames;
    private final Optional<Set<PathRule>> whitelistedPaths;
    private final Set<PathRule> blacklistedPaths;
    private final OptionalInt allowedLocalPort;
    private final OptionalInt allowedThreadCount;
    private final Set<PackageRule> blacklistedPackages;
    private final Set<PackageRule> whitelistedPackages;

    ArtemisSecurityConfigurationImpl(Class<?> testClass, Method testMethod, Path executionPath, Collection<String> whitelistedClassNames, Optional<Collection<PathRule>> whitelistedPaths, Collection<PathRule> blacklistedPaths, OptionalInt allowedLocalPort, OptionalInt allowedThreadCount, Set<PackageRule> blacklistedPackages, Set<PackageRule> whitelistedPackages) {
        this.testClass = Objects.requireNonNull(testClass);
        this.testMethod = Objects.requireNonNull(testMethod);
        this.executionPath = executionPath.toAbsolutePath();
        this.whitelistedClassNames = List.copyOf(whitelistedClassNames);
        this.whitelistedPaths = whitelistedPaths.map(Set::copyOf);
        this.blacklistedPaths = Set.copyOf(blacklistedPaths);
        this.allowedLocalPort = Objects.requireNonNull(allowedLocalPort);
        this.allowedThreadCount = Objects.requireNonNull(allowedThreadCount);
        this.blacklistedPackages = Set.copyOf(blacklistedPackages);
        this.whitelistedPackages = Set.copyOf(whitelistedPackages);
    }

    @Override
    public Class<?> testClass() {
        return this.testClass;
    }

    @Override
    public Method testMethod() {
        return this.testMethod;
    }

    @Override
    public Path executionPath() {
        return this.executionPath;
    }

    @Override
    public List<String> whitelistedClassNames() {
        return this.whitelistedClassNames;
    }

    @Override
    public Optional<Set<PathRule>> whitelistedPaths() {
        return this.whitelistedPaths;
    }

    @Override
    public Set<PathRule> blacklistedPaths() {
        return this.blacklistedPaths;
    }

    @Override
    public OptionalInt allowedLocalPort() {
        return this.allowedLocalPort;
    }

    @Override
    public OptionalInt allowedThreadCount() {
        return this.allowedThreadCount;
    }

    @Override
    public Set<PackageRule> blacklistedPackages() {
        return this.blacklistedPackages;
    }

    @Override
    public Set<PackageRule> whitelistedPackages() {
        return this.whitelistedPackages;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtemisSecurityConfigurationImpl)) {
            return false;
        }
        ArtemisSecurityConfigurationImpl other = (ArtemisSecurityConfigurationImpl)obj;
        return Objects.equals(this.executionPath, other.executionPath) && Objects.equals(this.testClass, other.testClass) && Objects.equals(this.testMethod, other.testMethod) && Objects.equals(this.whitelistedClassNames, other.whitelistedClassNames) && Objects.equals(this.allowedLocalPort, other.allowedLocalPort) && Objects.equals(this.allowedThreadCount, other.allowedThreadCount) && Objects.equals(this.whitelistedPaths, other.whitelistedPaths) && Objects.equals(this.blacklistedPaths, other.blacklistedPaths) && Objects.equals(this.blacklistedPackages, other.blacklistedPackages) && Objects.equals(this.whitelistedPackages, other.whitelistedPackages);
    }

    public int hashCode() {
        return Objects.hash(this.executionPath, this.testClass, this.testMethod, this.whitelistedClassNames, this.allowedThreadCount, this.whitelistedPaths, this.blacklistedPaths, this.blacklistedPackages, this.whitelistedPackages);
    }

    public String toString() {
        return String.format("ArtemisSecurityConfigurationImpl [whitelistedClassNames=%s, executionPath=%s, testClass=%s, testMethod=%s, whitelistedPaths=%s, blacklistedPaths=%s, allowedLocalPort=%s, allowedThreadCount=%s, blacklistedPackages=%s, whitelistedPackages=%s]", this.whitelistedClassNames, this.executionPath, this.testClass, this.testMethod, this.whitelistedPaths, this.blacklistedPaths, this.allowedLocalPort, this.allowedThreadCount, this.blacklistedPackages, this.whitelistedPackages);
    }

    @Override
    public String shortDesc() {
        return String.format("ASC-Impl [testMethod=%s, executionPath=%s, whitelistedPaths=%s, blacklistedPaths=%s, allowedLocalPort=%s]", this.testMethod, this.executionPath, this.whitelistedPaths, this.blacklistedPaths, this.allowedLocalPort);
    }
}

