/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.localization;

import de.tum.in.test.api.localization.UseLocale;
import java.util.Locale;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public class LocaleExtension
implements BeforeAllCallback,
AfterAllCallback {
    private Locale oldLocale;

    public void beforeAll(ExtensionContext context) throws Exception {
        Optional annot = AnnotationSupport.findAnnotation((Optional)context.getElement(), UseLocale.class);
        if (annot.isEmpty()) {
            return;
        }
        this.oldLocale = Locale.getDefault();
        Locale newLocale = new Locale(((UseLocale)annot.get()).value());
        Locale.setDefault(newLocale);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.oldLocale != null) {
            Locale.setDefault(this.oldLocale);
        }
    }
}

