/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.security.ConfigurationException;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public final class ArtemisSecurityConfigurationBuilder {
    private Optional<Class<?>> testClass = Optional.empty();
    private Optional<Method> testMethod = Optional.empty();
    private Path executionPath;
    private Set<String> whitelistedClassNames = new HashSet<String>();
    private Set<PathRule> whitelistedPaths;
    private Set<PathRule> blacklistedPaths = Set.of();
    private Set<PackageRule> blacklistedPackages = Set.of();
    private Set<PackageRule> whitelistedPackages = Set.of();
    private Set<Integer> allowedLocalPorts = Set.of();
    private OptionalInt allowLocalPortsAbove = OptionalInt.empty();
    private Set<Integer> excludedLocalPorts = Set.of();
    private OptionalInt allowedThreadCount = OptionalInt.empty();

    private ArtemisSecurityConfigurationBuilder() {
    }

    public ArtemisSecurityConfigurationBuilder withCurrentPath() {
        this.executionPath = Path.of("", new String[0]);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPath(Path executionPath) {
        this.executionPath = Objects.requireNonNull(executionPath);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPathWhitelist(Collection<PathRule> whitelistedPaths) {
        this.whitelistedPaths = Set.copyOf(whitelistedPaths);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPathWhitelist(Optional<? extends Collection<PathRule>> whitelistedPaths) {
        whitelistedPaths.ifPresentOrElse(this::withPathWhitelist, () -> {
            this.whitelistedPaths = null;
        });
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPathBlacklist(Collection<PathRule> blacklistedPaths) {
        this.blacklistedPaths = Set.copyOf(blacklistedPaths);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withTestClass(Class<?> testClass) {
        this.testClass = Optional.of(testClass);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withTestMethod(Method testMethod) {
        this.testMethod = Optional.of(testMethod);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withAllowedLocalPorts(Set<Integer> allowedLocalPorts) {
        this.allowedLocalPorts = Objects.requireNonNull(allowedLocalPorts);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withAllowLocalPortsAbove(OptionalInt allowLocalPortsAbove) {
        this.allowLocalPortsAbove = Objects.requireNonNull(allowLocalPortsAbove);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withExcludedLocalPorts(Set<Integer> excludedLocalPorts) {
        this.excludedLocalPorts = Objects.requireNonNull(excludedLocalPorts);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withAllowedThreadCount(OptionalInt allowedThreadCount) {
        this.allowedThreadCount = Objects.requireNonNull(allowedThreadCount);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder configureFromContext(TestContext context) {
        this.testClass = context.testClass();
        this.testMethod = context.testMethod();
        return this;
    }

    public ArtemisSecurityConfigurationBuilder addWhitelistedClassNames(String ... classNames) {
        return this.addWhitelistedClassNames(List.of(classNames));
    }

    public ArtemisSecurityConfigurationBuilder addWhitelistedClassNames(Collection<String> classNames) {
        this.whitelistedClassNames.addAll(classNames);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPackageBlacklist(Collection<PackageRule> packageBlacklist) {
        this.blacklistedPackages = Set.copyOf(packageBlacklist);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPackageWhitelist(Collection<PackageRule> packageWhitelist) {
        this.whitelistedPackages = Set.copyOf(packageWhitelist);
        return this;
    }

    public ArtemisSecurityConfiguration build() {
        this.validate();
        return new ArtemisSecurityConfiguration(this.testClass, this.testMethod, this.executionPath, this.whitelistedClassNames, Optional.ofNullable(this.whitelistedPaths), this.blacklistedPaths, this.allowedLocalPorts, this.allowLocalPortsAbove, this.excludedLocalPorts, this.allowedThreadCount, this.blacklistedPackages, this.whitelistedPackages);
    }

    private void validate() {
        if (this.allowedThreadCount.orElse(0) < 0) {
            throw new ConfigurationException("Allowed thread count must be non-negative");
        }
        if (!Collections.disjoint(this.allowedLocalPorts, this.excludedLocalPorts)) {
            throw new ConfigurationException("Allowed and excluded local ports must not intersect");
        }
        this.allowedLocalPorts.forEach(ArtemisSecurityConfigurationBuilder::validatePortRange);
        this.excludedLocalPorts.forEach(ArtemisSecurityConfigurationBuilder::validatePortRange);
        this.allowLocalPortsAbove.ifPresent(value -> {
            ArtemisSecurityConfigurationBuilder.validatePortRange(value);
            if (this.allowedLocalPorts.stream().anyMatch(allowed -> allowed > value)) {
                throw new ConfigurationException("Allowed local port values must not be greater than allowPortsAbove");
            }
            if (this.excludedLocalPorts.stream().anyMatch(exclusion -> exclusion <= value)) {
                throw new ConfigurationException("Local ports exclusion values must be greater than allowPortsAbove");
            }
        });
    }

    private static void validatePortRange(int value) {
        if (value < 0) {
            throw new ConfigurationException("Allow local port: port number must not be negative");
        }
        if (value > 65535) {
            throw new ConfigurationException("Allow local port: port number must not exceed MAXIMUM");
        }
    }

    public static ArtemisSecurityConfigurationBuilder create() {
        return new ArtemisSecurityConfigurationBuilder();
    }
}

