/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.AbstractLine;
import de.tum.in.test.api.io.StaticLine;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface Line {
    public String text();

    public boolean isComplete();

    public int lineNumber();

    public String toString();

    default public boolean contentEquals(CharSequence cs) {
        return this.text().contentEquals(cs);
    }

    public static AbstractLine of(String text) {
        return new StaticLine(text);
    }

    public static List<AbstractLine> linesOf(String multiLineText) {
        return Arrays.stream(multiLineText.split("\r?\n|\r", -1)).map(Line::of).collect(Collectors.toUnmodifiableList());
    }

    public static String joinLinesToString(Collection<? extends Line> lines, CharSequence delimiter) {
        return lines.stream().map(Line::text).collect(Collectors.joining(delimiter));
    }
}

