/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.Line;
import de.tum.in.test.api.io.LineProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class TestInStream
extends InputStream {
    private final LineProvider lineProvider;
    private ByteArrayInputStream input;

    TestInStream(LineProvider lineProvider) {
        this.lineProvider = Objects.requireNonNull(lineProvider);
    }

    @Override
    public int read() throws IOException {
        if (this.input == null) {
            this.tryLoadNextLine(true);
        }
        int res = this.input.read();
        if (this.input.available() == 0) {
            this.input = null;
        }
        return res;
    }

    @Override
    public int available() throws IOException {
        if (this.input == null) {
            this.tryLoadNextLine(false);
        }
        return this.input == null ? 0 : this.input.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.input == null) {
            this.tryLoadNextLine(true);
        }
        int res = this.input.read(b, off, len);
        if (this.input.available() == 0) {
            this.input = null;
        }
        return res;
    }

    void resetInternalState() {
        this.input = null;
    }

    private void tryLoadNextLine(boolean force) {
        if (force || this.lineProvider.hasNextLine()) {
            Line currentLine = this.lineProvider.getNextLine();
            byte[] bytes = currentLine.text().concat("\n").getBytes(StandardCharsets.UTF_8);
            this.input = new ByteArrayInputStream(bytes);
        }
    }
}

