/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SimpleThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import java.util.Set;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.ValueWrapper;

enum AssertionFailedErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(AssertionFailedError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t) {
        AssertionFailedError afe = (AssertionFailedError)t;
        ValueWrapper expected = BlacklistedInvoker.invoke(() -> ((AssertionFailedError)afe).getExpected());
        ValueWrapper actual = BlacklistedInvoker.invoke(() -> ((AssertionFailedError)afe).getActual());
        if (expected == null && actual == null) {
            return SimpleThrowableSanitizer.INSTANCE.sanitize((Throwable)afe);
        }
        AssertionFailedError newAfe = new AssertionFailedError(BlacklistedInvoker.invoke(() -> afe.getMessage()), AssertionFailedErrorSanitizer.sanitizeValue(expected), AssertionFailedErrorSanitizer.sanitizeValue(actual));
        SanitizationUtils.copyThrowableInfoSafe((Throwable)afe, (Throwable)newAfe);
        return newAfe;
    }

    private static Object sanitizeValue(ValueWrapper vw) {
        if (vw == null) {
            return null;
        }
        return SanitizationUtils.sanitizeWithinScopeOf(vw.getType(), () -> BlacklistedInvoker.invoke(() -> ((ValueWrapper)vw).getStringRepresentation()));
    }
}

