/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.ConfigurationUtils;
import de.tum.in.test.api.internal.PrivilegedException;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.internal.ThrowableUtils;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReportingUtils.class);

    private ReportingUtils() {
    }

    public static <T> T doProceedAndPostProcess(InvocationInterceptor.Invocation<T> invocation, TestContext context) throws Throwable {
        try {
            return (T)invocation.proceed();
        }
        catch (Throwable t) {
            throw ReportingUtils.processThrowable(t, context);
        }
    }

    public static Throwable processThrowable(Throwable t, TestContext context) {
        Optional<String> nonprivilegedFailureMessage = ConfigurationUtils.getNonprivilegedFailureMessage(context);
        if (nonprivilegedFailureMessage.isPresent()) {
            return ReportingUtils.processThrowablePrivilegedOnly(t, nonprivilegedFailureMessage.get());
        }
        return ReportingUtils.processThrowableRegularly(t);
    }

    private static Throwable processThrowableRegularly(Throwable t) {
        Throwable newT = ReportingUtils.trySanitizeThrowable(t);
        ReportingUtils.tryPostProcessMessageOrAddSuppressed(newT, ReportingUtils::postProcessMessage);
        if (!(newT instanceof AssertionError)) {
            ReportingUtils.addStackframeInfoToMessage(newT);
        }
        return newT;
    }

    private static Throwable processThrowablePrivilegedOnly(Throwable t, String nonprivilegedFailureMessage) {
        Object newT = t instanceof PrivilegedException ? ReportingUtils.trySanitizeThrowable(t) : new AssertionError((Object)nonprivilegedFailureMessage);
        ReportingUtils.tryPostProcessMessageOrAddSuppressed(t, ReportingUtils::postProcessMessage);
        return newT;
    }

    private static Throwable trySanitizeThrowable(Throwable t) {
        Throwable newT;
        String name = "unknown";
        try {
            name = t.getClass().getName();
            newT = ThrowableSanitizer.sanitize(t);
        }
        catch (Throwable sanitizationError) {
            return ReportingUtils.handleSanitizationFailure(name, sanitizationError);
        }
        return newT;
    }

    private static Throwable handleSanitizationFailure(String name, Throwable error) {
        String info = BlacklistedInvoker.invokeOrElse(error::toString, () -> error.getClass().toString());
        LOG.error("Sanitization failed for {} with error {}", (Object)name, (Object)info);
        return new SecurityException(name + " thrown, but cannot be displayed: " + info);
    }

    private static void addStackframeInfoToMessage(Throwable newT) {
        StackTraceElement[] stackTrace = BlacklistedInvoker.invoke(newT::getStackTrace);
        Optional<StackTraceElement> first = ArtemisSecurityManager.firstNonWhitelisted(stackTrace);
        if (first.isPresent()) {
            String call = first.get().toString();
            ReportingUtils.tryPostProcessMessageOrAddSuppressed(newT, old -> Objects.toString(old, "") + "\n" + Messages.formatLocalized("reporting.problem_location_hint", call));
        }
    }

    private static String tryPostProcessMessageOrAddSuppressed(Throwable t, UnaryOperator<String> transform) {
        String newMessage = (String)transform.apply(ThrowableUtils.getDetailMessage(t));
        ThrowableUtils.setDetailMessage(t, newMessage);
        return newMessage;
    }

    private static String postProcessMessage(String message) {
        return message == null ? null : message.replace("\r", "");
    }

    static {
        ThrowableSanitizer.sanitize(null);
    }
}

