/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.error.AssertJMultipleFailuresError;
import org.opentest4j.MultipleFailuresError;

enum MultipleFailuresErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private static final String HEADING_NAME = "heading";
    private final Set<Class<? extends Throwable>> types = Set.of(MultipleFailuresError.class, AssertJMultipleFailuresError.class);
    private static final VarHandle HEADING;

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t) {
        String heading = HEADING.get(t);
        List<Throwable> failures = ((MultipleFailuresError)t).getFailures().stream().map(ThrowableSanitizer::sanitize).collect(Collectors.toList());
        MultipleFailuresError mfe = MultipleFailuresErrorSanitizer.createNewInstance(t, heading, failures);
        SanitizationUtils.copyThrowableInfoSafe(t, (Throwable)mfe);
        return mfe;
    }

    private static MultipleFailuresError createNewInstance(Throwable t, String heading, List<Throwable> failures) {
        if (t.getClass().equals(MultipleFailuresError.class)) {
            return new MultipleFailuresError(heading, failures);
        }
        return new AssertJMultipleFailuresError(heading, failures);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(MultipleFailuresError.class, MethodHandles.lookup());
            HEADING = lookup.findVarHandle(MultipleFailuresError.class, HEADING_NAME, String.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

