/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.AbstractLine;
import de.tum.in.test.api.io.DynamicLine;
import de.tum.in.test.api.io.Line;
import de.tum.in.test.api.io.LineAcceptor;
import de.tum.in.test.api.io.OutputTestOptions;
import java.nio.CharBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.ValueWrapper;

@API(status=API.Status.MAINTAINED)
public final class OutputTester
implements LineAcceptor {
    private static final int MAX_SPACES = 16;
    private static final int RANDOM_BOUND = 256;
    private static final char[] SPACES = " ".repeat(16).toCharArray();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final Pattern EXPECTED_LINE_PATTERN = Pattern.compile("`\\(\\?x\\)#([0-9A-F]{8})\\R.+`(?=[^`]*(?:\\R|$))");
    private final List<Line> actualOutput = new ArrayList<Line>();
    private final long randomBits = SECURE_RANDOM.nextLong();
    private final String randomString = Long.toUnsignedString(this.randomBits, 16);

    @Override
    public void acceptOutput(CharBuffer output) {
        DynamicLine currentLine;
        if (output.length() == 0) {
            return;
        }
        if (this.getCurrentLine().map(Line::isComplete).orElse(true).booleanValue()) {
            currentLine = new DynamicLine();
            this.addNewLine(currentLine);
        } else {
            currentLine = (DynamicLine)this.getCurrentLine().get();
        }
        int lastPos = 0;
        boolean lastWasCarriageReturn = false;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if (c == '\r' || c == '\n') {
                if (c == '\n' && lastWasCarriageReturn) {
                    ++lastPos;
                } else {
                    currentLine.append(output.subSequence(lastPos, i));
                    currentLine.complete();
                    currentLine = new DynamicLine();
                    this.addNewLine(currentLine);
                    lastPos = i + 1;
                }
                lastWasCarriageReturn = c == '\r';
                continue;
            }
            if (!lastWasCarriageReturn) continue;
            lastWasCarriageReturn = false;
        }
        if (lastPos != output.length()) {
            currentLine.append(output.subSequence(lastPos, output.length()));
        }
    }

    private void addNewLine(AbstractLine line) {
        this.actualOutput.add(line);
        line.setLineNumber(this.actualOutput.size());
    }

    Optional<Line> getCurrentLine() {
        if (this.actualOutput.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.actualOutput.get(this.actualOutput.size() - 1));
    }

    public void resetOutput() {
        this.actualOutput.clear();
    }

    @Deprecated(since="1.3.2")
    public List<Line> getOutput() {
        return Collections.unmodifiableList(this.actualOutput);
    }

    public List<Line> getLines(OutputTestOptions ... outputOptions) {
        return Collections.unmodifiableList(this.processLines(outputOptions));
    }

    public String getOutputAsString(OutputTestOptions ... outputOptions) {
        return this.processLines(outputOptions).stream().map(Line::text).collect(Collectors.joining("\n"));
    }

    public List<String> getLinesAsString(OutputTestOptions ... outputOptions) {
        return this.processLines(outputOptions).stream().map(Line::text).collect(Collectors.toUnmodifiableList());
    }

    public AbstractStringAssert<?> assertThat(OutputTestOptions ... outputOptions) {
        return Assertions.assertThat((String)this.getOutputAsString(outputOptions));
    }

    public ListAssert<String> assertThatLines(OutputTestOptions ... outputOptions) {
        return Assertions.assertThat(this.getLinesAsString(outputOptions));
    }

    public void assertLinesMatch(String message, String ... expectedLines) {
        this.assertLinesMatch(message, OutputTestOptions.NONE, expectedLines);
    }

    public void assertLinesMatch(String message, OutputTestOptions[] outputOptions, String ... expectedLines) {
        List<String> lines = Stream.of(expectedLines).flatMap(String::lines).collect(Collectors.toList());
        int lineCount = lines.size();
        ArrayList<String> expectedLinePatterns = new ArrayList<String>();
        for (int i = 0; i < lineCount; ++i) {
            boolean isFastForward;
            String line = (String)lines.get(i);
            StringBuilder newLine = new StringBuilder(line);
            boolean isRegEx = OutputTester.isRegExLine(line);
            boolean bl = isFastForward = !isRegEx && line.startsWith(">>") && line.endsWith(">>");
            if (OutputTester.startsWithEscape(line)) {
                newLine.deleteCharAt(0);
            } else if (isRegEx) {
                newLine.delete(0, 2).delete(newLine.length() - 2, newLine.length());
            }
            if (!isFastForward) {
                if (!isRegEx) {
                    newLine.replace(0, newLine.length(), Pattern.quote(newLine.toString()));
                }
                newLine.insert(0, String.format("(?x)#%08X%n", i));
                newLine.append('#').append(this.randomString);
            } else {
                int spacesRandom = ThreadLocalRandom.current().nextInt(256);
                int front = spacesRandom % 16;
                int back = spacesRandom / 16;
                newLine.insert(2, SPACES, 0, front);
                newLine.insert(newLine.length() - 2, SPACES, 0, back);
            }
            expectedLinePatterns.add(newLine.toString());
        }
        List<String> linesAsString = this.getLinesAsString(outputOptions);
        try {
            org.junit.jupiter.api.Assertions.assertLinesMatch(expectedLinePatterns, linesAsString, (String)message);
        }
        catch (AssertionFailedError afe) {
            throw OutputTester.tryCleanUpAssertionFailedError(lines, afe);
        }
        catch (NoSuchElementException nsee) {
            throw new AssertionFailedError("The output does not contain enough lines for the test to work, only " + linesAsString.size() + " lines found.");
        }
    }

    private static AssertionFailedError tryCleanUpAssertionFailedError(List<String> lines, AssertionFailedError afe) {
        String failureMessage = afe.getMessage();
        Matcher matcher = EXPECTED_LINE_PATTERN.matcher(failureMessage);
        if (matcher.find()) {
            int lineNumber = Integer.parseInt(matcher.group(1), 16);
            String expectedLine = lines.get(lineNumber);
            StringBuilder cleanExpectedLine = new StringBuilder(expectedLine);
            if (OutputTester.startsWithEscape(expectedLine)) {
                cleanExpectedLine.append('`').setCharAt(0, '`');
            } else if (OutputTester.isRegExLine(expectedLine)) {
                cleanExpectedLine.delete(0, 2).delete(cleanExpectedLine.length() - 2, cleanExpectedLine.length()).insert(0, "matches regular expression: `").append('`');
            } else {
                cleanExpectedLine.insert(0, '`').append('`');
            }
            String newFailureMessage = matcher.replaceFirst(cleanExpectedLine.toString());
            return new AssertionFailedError(newFailureMessage, OutputTester.tryReplaceExpected(lines, afe.getExpected()), afe.getActual().getEphemeralValue());
        }
        return afe;
    }

    private static Object tryReplaceExpected(List<String> expectedLines, ValueWrapper expectedValueWrapper) {
        Object value = expectedValueWrapper.getEphemeralValue();
        if (!(value instanceof String)) {
            return value;
        }
        return expectedLines.stream().map(line -> {
            if (OutputTester.startsWithEscape(line)) {
                return line.substring(1);
            }
            if (OutputTester.isRegExLine(line)) {
                return line.substring(2, line.length() - 2);
            }
            return line;
        }).collect(Collectors.joining("\n"));
    }

    private static boolean startsWithEscape(String line) {
        return line.startsWith("\\||") || line.startsWith("\\>>");
    }

    private static boolean isRegExLine(String expectedLine) {
        return expectedLine.startsWith("||") && expectedLine.endsWith("||");
    }

    private List<Line> processLines(OutputTestOptions ... outputOptions) {
        boolean ignoreLastEmpty;
        boolean bl = ignoreLastEmpty = !OutputTestOptions.DONT_IGNORE_LAST_EMPTY_LINE.isIn(outputOptions);
        if (ignoreLastEmpty && !this.actualOutput.isEmpty() && this.actualOutput.get(this.actualOutput.size() - 1).text().isEmpty()) {
            return this.actualOutput.subList(0, this.actualOutput.size() - 1);
        }
        return this.actualOutput;
    }
}

