/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;

@API(status=API.Status.EXPERIMENTAL)
public class DynamicField<T>
implements Checkable {
    private final DynamicClass<?> owner;
    private final List<String> name;
    private final DynamicClass<T> type;
    private final boolean ignoreCase;
    private Field field;

    public DynamicField(DynamicClass<?> dClass, Class<T> fType, boolean ignoreCase, String ... possibleNames) {
        this(dClass, DynamicClass.toDynamic(fType), ignoreCase, possibleNames);
    }

    public DynamicField(DynamicClass<?> dClass, DynamicClass<T> fType, boolean ignoreCase, String ... possibleNames) {
        this.owner = Objects.requireNonNull(dClass);
        this.name = ignoreCase ? Stream.of(possibleNames).map(String::toLowerCase).collect(Collectors.toUnmodifiableList()) : List.of(possibleNames);
        this.type = Objects.requireNonNull(fType);
        this.ignoreCase = ignoreCase;
    }

    public Field toField() {
        if (this.field == null) {
            Optional<Field> of = this.findField(this.owner.toClass());
            if (of.isPresent()) {
                this.field = of.get();
                this.field.setAccessible(true);
            } else {
                Assertions.fail((String)("Feld " + this.name + " konnte nicht gefunden werden"));
            }
        }
        return this.field;
    }

    public T getOf(Object o) {
        try {
            return (T)this.toField().get(o);
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)("Feld " + this.name + " der Klasse " + this.owner + " konnte nicht aufgerufen werden, Zugriff auf das Feld nicht m\u00f6glich"), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)("Feld " + this.name + " von Klasse " + this.owner + " wurde nicht auf einem passenden Objekt aufgerufen (-> Testfehler)"), (Throwable)e);
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("Feld " + this.name + " der Klasse " + this.owner + " kann nicht nach " + this.type.getName() + "gecastet werden"), (Throwable)e);
        }
        return null;
    }

    public T getStatic() {
        try {
            return this.getOf(null);
        }
        catch (NullPointerException e) {
            Assertions.fail((String)("Feld " + this.name + " der Klasse " + this.owner + " ist nicht statisch"), (Throwable)e);
            return null;
        }
    }

    private Optional<Field> findField(Class<?> c) {
        return this.fieldsOf(c).stream().filter(f -> this.name.contains(this.ignoreCase ? f.getName().toLowerCase() : f.getName())).findFirst();
    }

    private List<Field> fieldsOf(Class<?> c) {
        ArrayList<Field> al = new ArrayList<Field>();
        for (Class<?> current = c; current != Object.class; current = current.getSuperclass()) {
            for (Field ff : current.getDeclaredFields()) {
                if (!this.type.toClass().isAssignableFrom(ff.getType())) continue;
                al.add(ff);
            }
        }
        return al;
    }

    public String toString() {
        return this.owner.toString() + "." + this.name;
    }

    @Override
    public void check(Check ... checks) {
        int modifiers = this.toField().getModifiers();
        String desc = "Feld " + this;
        for (Check check : checks) {
            check.checkModifiers(modifiers, desc);
        }
    }
}

