/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.ActivateHiddenBefore;
import de.tum.in.test.api.Deadline;
import de.tum.in.test.api.ExtendedDeadline;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.internal.TestType;
import de.tum.in.test.api.localization.Messages;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public final class TestGuardUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestGuardUtils.class);
    private static final String ZONE_ID_START_PATTERN = "[-+A-Za-z].*";
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?:(?<d>\\d+)d)?\\s*(?:\\b(?<h>\\d+)h)?\\s*(?:\\b(?<m>\\d+)m)?", 2);

    private TestGuardUtils() {
    }

    public static void checkForHidden(TestContext context) {
        if (TestGuardUtils.hasAnnotationType(context, TestType.HIDDEN)) {
            ZonedDateTime finalDeadline;
            if (TestGuardUtils.hasAnnotationType(context, TestType.PUBLIC)) {
                throw new AnnotationFormatError(Messages.formatLocalized("test_guard.test_cannot_be_public_and_hidden", context.displayName()));
            }
            ZonedDateTime now = ZonedDateTime.now();
            if (now.isAfter(finalDeadline = TestGuardUtils.extractDeadline(context))) {
                return;
            }
            Optional<ZonedDateTime> activationBefore = TestGuardUtils.extractActivationBefore(context);
            if (activationBefore.map(now::isBefore).orElse(false).booleanValue()) {
                return;
            }
            Assertions.fail((String)Messages.localized("test_guard.hidden_test_before_deadline_message"));
        } else if (TestGuardUtils.hasAnnotation(context, Deadline.class) || TestGuardUtils.hasAnnotation(context, ExtendedDeadline.class)) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.public_test_cannot_have_deadline", context.displayName()));
        }
    }

    public static boolean hasAnnotation(TestContext context, Class<? extends Annotation> type) {
        Optional<Method> element = context.testMethod();
        return AnnotationSupport.findAnnotation(element, type).isPresent();
    }

    public static boolean hasAnnotationType(TestContext context, TestType type) {
        return context.findTestType().orElse(null) == type;
    }

    public static ZonedDateTime extractDeadline(TestContext context) {
        Optional<ZonedDateTime> deadline = TestGuardUtils.extractDeadline(context.testClass(), context.testMethod());
        if (deadline.isPresent()) {
            return deadline.get();
        }
        throw new AnnotationFormatError(Messages.formatLocalized("test_guard.hidden_test_missing_deadline", context.displayName()));
    }

    public static Optional<ZonedDateTime> extractDeadline(Optional<Class<?>> testClass, Optional<Method> testMethod) {
        Optional<ZonedDateTime> methodLevel = TestGuardUtils.getDeadlineOf(testMethod);
        Optional<Duration> methodDelta = TestGuardUtils.getExtensionDurationOf(testMethod);
        if (methodLevel.isPresent()) {
            return methodLevel.map(dl -> dl.plus(methodDelta.orElse(Duration.ZERO)));
        }
        Optional<ZonedDateTime> classLevel = AnnotationSupport.findAnnotation(testClass, Deadline.class).map(Deadline::value).map(TestGuardUtils::parseDeadline);
        Optional<Duration> classDelta = AnnotationSupport.findAnnotation(testClass, ExtendedDeadline.class).map(ExtendedDeadline::value).map(TestGuardUtils::parseDuration);
        return classLevel.map(dl -> dl.plus(classDelta.orElse(Duration.ZERO))).map(dl -> dl.plus(methodDelta.orElse(Duration.ZERO)));
    }

    public static Optional<ZonedDateTime> extractActivationBefore(TestContext context) {
        Optional<ZonedDateTime> methodLevel = TestGuardUtils.getActivationBeforeOf(context.testMethod());
        return methodLevel.or(() -> TestGuardUtils.getActivationBeforeOf(context.testClass()));
    }

    public static Optional<ZonedDateTime> getDeadlineOf(Optional<? extends AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Deadline.class).map(Deadline::value).map(TestGuardUtils::parseDeadline);
    }

    public static Optional<Duration> getExtensionDurationOf(Optional<? extends AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, ExtendedDeadline.class).map(ExtendedDeadline::value).map(TestGuardUtils::parseDuration);
    }

    public static Optional<ZonedDateTime> getActivationBeforeOf(Optional<? extends AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, ActivateHiddenBefore.class).map(ActivateHiddenBefore::value).map(TestGuardUtils::parseDeadline);
    }

    @API(status=API.Status.INTERNAL)
    public static ZonedDateTime parseDeadline(String deadlineString) {
        try {
            ZoneId zone;
            String[] parts = TestGuardUtils.splitIntoDateTimeAndZone(deadlineString);
            String dateTimeString = parts[0];
            String zoneString = parts[1];
            LocalDateTime dateTime = LocalDateTime.parse(dateTimeString.replace(' ', 'T'));
            if (zoneString == null) {
                zone = ZoneId.systemDefault();
                LOG.warn("No time zone found for deadline \"{}\", using system default \"{}\" now. Please consider setting a time zone in case the build agents have a different time zone set.", (Object)deadlineString, (Object)zone);
            } else {
                zone = ZoneId.of(zoneString, ZoneId.SHORT_IDS);
            }
            return dateTime.atZone(zone);
        }
        catch (DateTimeParseException e) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.invalid_deadline_format", deadlineString), e);
        }
    }

    private static String[] splitIntoDateTimeAndZone(String deadlineString) {
        int firstSpace = deadlineString.indexOf(32);
        if (firstSpace == -1) {
            return new String[]{deadlineString, null};
        }
        int lastSpace = deadlineString.lastIndexOf(32);
        String potentialZoneIdString = deadlineString.substring(lastSpace + 1);
        if (firstSpace != lastSpace || potentialZoneIdString.matches(ZONE_ID_START_PATTERN)) {
            return new String[]{deadlineString.substring(0, lastSpace), potentialZoneIdString};
        }
        return new String[]{deadlineString, null};
    }

    @API(status=API.Status.INTERNAL)
    public static Duration parseDuration(String durationString) {
        Matcher matcher = DURATION_PATTERN.matcher(durationString);
        if (!matcher.matches()) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.invalid_extended_deadline_format", durationString));
        }
        Integer d = Optional.ofNullable(matcher.group("d")).map(Integer::parseInt).orElse(0);
        Integer h = Optional.ofNullable(matcher.group("h")).map(Integer::parseInt).orElse(0);
        Integer m = Optional.ofNullable(matcher.group("m")).map(Integer::parseInt).orElse(0);
        Duration duration = Duration.ofDays(d.intValue()).plusHours(h.intValue()).plusMinutes(m.intValue());
        if (duration.isZero() || duration.isNegative()) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.extended_deadline_zero_or_negative", durationString));
        }
        return duration;
    }
}

