/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.ArbitraryThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.AssertionFailedErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.ExceptionInInitializerErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.MultipleAssertionsErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.MultipleFailuresErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.PrivilegedExceptionSanitizer;
import de.tum.in.test.api.internal.sanitization.SafeTypeThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SoftAssertionErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSets;
import de.tum.in.test.api.util.UnexpectedExceptionError;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class ThrowableSanitizer {
    private static final List<SpecificThrowableSanitizer> SANITIZERS;

    private ThrowableSanitizer() {
    }

    public static Throwable sanitize(Throwable t) {
        return ThrowableSanitizer.sanitize(t, MessageTransformer.IDENTITY);
    }

    public static Throwable sanitize(Throwable t, MessageTransformer messageTransformer) {
        if (t == null) {
            return null;
        }
        return SanitizationUtils.sanitizeWithinScopeOf(t, () -> {
            if (UnexpectedExceptionError.class.equals(t.getClass())) {
                return t;
            }
            Optional<SpecificThrowableSanitizer> firstPossibleSan = SANITIZERS.stream().filter(s -> s.canSanitize(t)).findFirst();
            return firstPossibleSan.orElse(ArbitraryThrowableSanitizer.INSTANCE).sanitize(t, messageTransformer);
        });
    }

    static {
        ThrowableSets.init();
        SANITIZERS = List.of(SafeTypeThrowableSanitizer.INSTANCE, AssertionFailedErrorSanitizer.INSTANCE, PrivilegedExceptionSanitizer.INSTANCE, MultipleFailuresErrorSanitizer.INSTANCE, MultipleAssertionsErrorSanitizer.INSTANCE, ExceptionInInitializerErrorSanitizer.INSTANCE, SoftAssertionErrorSanitizer.INSTANCE);
    }
}

