/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.AbstractLine;

final class DynamicLine
extends AbstractLine {
    private StringBuilder textUnderConstruction;
    private String text;

    DynamicLine(CharSequence text) {
        this.textUnderConstruction = new StringBuilder(text);
        if (AbstractLine.containsLineBreaks(text)) {
            throw new IllegalArgumentException("Line must not contain any new lines");
        }
    }

    DynamicLine() {
        this.textUnderConstruction = new StringBuilder();
    }

    public void complete() {
        if (this.isComplete()) {
            throw new IllegalStateException("Line already complete");
        }
        this.text = this.textUnderConstruction.toString();
        this.textUnderConstruction = null;
    }

    public void append(CharSequence s) {
        if (this.isComplete()) {
            throw new IllegalStateException("Line already completed");
        }
        if (AbstractLine.containsLineBreaks(s)) {
            throw new IllegalArgumentException("Line must not contain any new lines");
        }
        this.textUnderConstruction.append(s);
    }

    @Override
    public String text() {
        return this.text != null ? this.text : this.textUnderConstruction.toString();
    }

    @Override
    public boolean isComplete() {
        return this.text != null;
    }
}

