/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jupiter;

import de.tum.in.test.api.internal.ReportingUtils;
import de.tum.in.test.api.internal.TestGuardUtils;
import de.tum.in.test.api.internal.TestType;
import de.tum.in.test.api.jupiter.JupiterArtemisTest;
import de.tum.in.test.api.jupiter.JupiterContext;
import de.tum.in.test.api.jupiter.UnifiedInvocationInterceptor;
import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public final class JupiterTestGuard
implements UnifiedInvocationInterceptor,
DisplayNameGenerator {
    private final DisplayNameGenerator defaultNameGen = new DisplayNameGenerator.ReplaceUnderscores();

    @Override
    public <T> T interceptGenericInvocation(InvocationInterceptor.Invocation<T> invocation, ExtensionContext extensionContext, Optional<ReflectiveInvocationContext<?>> invocationContext) throws Throwable {
        JupiterContext jupiterContext = JupiterContext.of(extensionContext);
        TestGuardUtils.checkForHidden(jupiterContext);
        return ReportingUtils.doProceedAndPostProcess(invocation, jupiterContext);
    }

    public String generateDisplayNameForClass(Class<?> testClass) {
        return this.defaultNameGen.generateDisplayNameForClass(testClass);
    }

    public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        return this.defaultNameGen.generateDisplayNameForNestedClass(nestedClass);
    }

    public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        if (AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, JupiterArtemisTest.class).map(JupiterArtemisTest::value).orElse(null) == TestType.HIDDEN) {
            Optional<ZonedDateTime> deadline = TestGuardUtils.extractDeadline(Optional.of(testClass), Optional.of(testMethod));
            String name = testMethod.toString();
            if (deadline.isEmpty()) {
                return Messages.formatLocalized("test_guard.obfuscate_hidden_test_missing_deadline", name);
            }
            if (ZonedDateTime.now().isBefore(deadline.get())) {
                return String.format("Hidden Test %08X", name.hashCode());
            }
        }
        return this.defaultNameGen.generateDisplayNameForMethod(testClass, testMethod);
    }
}

