/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.structural.StructuralTestProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;

public abstract class AttributeTestProvider
extends StructuralTestProvider {
    protected DynamicContainer generateTestsForAllClasses() throws URISyntaxException {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        if (structureOracleJSON == null) {
            Assertions.fail((String)"The AttributeTest test can only run if the structural oracle (test.json) is present. If you do not provide it, delete AttributeTest.java!");
        }
        for (int i = 0; i < structureOracleJSON.length(); ++i) {
            JSONObject expectedClassJSON = structureOracleJSON.getJSONObject(i);
            if (!expectedClassJSON.has("class") || !expectedClassJSON.has("attributes") && !expectedClassJSON.has("enumValues")) continue;
            JSONObject expectedClassPropertiesJSON = expectedClassJSON.getJSONObject("class");
            String expectedClassName = expectedClassPropertiesJSON.getString("name");
            String expectedPackageName = expectedClassPropertiesJSON.getString("package");
            StructuralTestProvider.ExpectedClassStructure expectedClassStructure = new StructuralTestProvider.ExpectedClassStructure(expectedClassName, expectedPackageName, expectedClassJSON);
            tests.add(DynamicTest.dynamicTest((String)("testAttributes[" + expectedClassName + "]"), () -> this.testAttributes(expectedClassStructure)));
        }
        if (tests.isEmpty()) {
            Assertions.fail((String)"No tests for attributes available in the structural oracle (test.json). Either provide attributes information or delete AttributeTest.java!");
        }
        return DynamicContainer.dynamicContainer((String)this.getClass().getName(), (URI)new URI(this.getClass().getName()), tests.stream());
    }

    protected void testAttributes(StructuralTestProvider.ExpectedClassStructure expectedClassStructure) {
        String expectedClassName = expectedClassStructure.getExpectedClassName();
        Class<?> observedClass = AttributeTestProvider.findClassForTestType(expectedClassStructure, "attribute");
        if (observedClass == null) {
            Assertions.fail((String)("The class " + expectedClassName + " was not found for attribute test"));
            return;
        }
        if (expectedClassStructure.hasProperty("attributes")) {
            JSONArray expectedAttributes = expectedClassStructure.getPropertyAsJsonArray("attributes");
            this.checkAttributes(expectedClassName, observedClass, expectedAttributes);
        }
        if (expectedClassStructure.hasProperty("enumValues")) {
            JSONArray expectedEnumValues = expectedClassStructure.getPropertyAsJsonArray("enumValues");
            this.checkEnumValues(expectedClassName, observedClass, expectedEnumValues);
        }
    }

    protected void checkAttributes(String expectedClassName, Class<?> observedClass, JSONArray expectedAttributes) {
        for (int i = 0; i < expectedAttributes.length(); ++i) {
            JSONObject expectedAttribute = expectedAttributes.getJSONObject(i);
            String expectedName = expectedAttribute.getString("name");
            String expectedTypeName = expectedAttribute.getString("type");
            JSONArray expectedModifiers = AttributeTestProvider.getExpectedJsonProperty(expectedAttribute, "modifiers");
            JSONArray expectedAnnotations = AttributeTestProvider.getExpectedJsonProperty(expectedAttribute, "annotations");
            boolean nameIsCorrect = false;
            boolean typeIsCorrect = false;
            boolean modifiersAreCorrect = false;
            boolean annotationsAreCorrect = false;
            for (Field observedAttribute : observedClass.getDeclaredFields()) {
                if (!expectedName.equals(observedAttribute.getName())) continue;
                nameIsCorrect = true;
                typeIsCorrect = AttributeTestProvider.checkExpectedType(observedAttribute.getType(), observedAttribute.getGenericType(), expectedTypeName);
                modifiersAreCorrect = AttributeTestProvider.checkModifiers(Modifier.toString(observedAttribute.getModifiers()).split(" "), expectedModifiers);
                annotationsAreCorrect = AttributeTestProvider.checkAnnotations(observedAttribute.getAnnotations(), expectedAnnotations);
                if (typeIsCorrect && modifiersAreCorrect && annotationsAreCorrect) break;
            }
            AttributeTestProvider.checkAttributeCorrectness(nameIsCorrect, typeIsCorrect, modifiersAreCorrect, annotationsAreCorrect, expectedName, expectedClassName);
        }
    }

    private static void checkAttributeCorrectness(boolean nameIsCorrect, boolean typeIsCorrect, boolean modifiersAreCorrect, boolean annotationsAreCorrect, String expectedName, String expectedClassName) {
        String expectedAttributeInformation = "the expected attribute '" + expectedName + "' of the class '" + expectedClassName + "'";
        if (!nameIsCorrect) {
            Assertions.fail((String)("The name of " + expectedAttributeInformation + " is not implemented as expected."));
        }
        if (!typeIsCorrect) {
            Assertions.fail((String)("The type of " + expectedAttributeInformation + " is not implemented as expected."));
        }
        if (!modifiersAreCorrect) {
            Assertions.fail((String)("The modifier(s) (access type, abstract, etc.) of " + expectedAttributeInformation + " are not implemented as expected."));
        }
        if (!annotationsAreCorrect) {
            Assertions.fail((String)("The annotation(s) of " + expectedAttributeInformation + " are not implemented as expected."));
        }
    }

    protected void checkEnumValues(String expectedClassName, Class<?> observedClass, JSONArray expectedEnumValues) {
        ?[] observedEnumValues = observedClass.getEnumConstants();
        if (observedEnumValues == null) {
            Assertions.fail((String)("The enum '" + expectedClassName + "' does not contain any enum constants. Make sure to implement them."));
            return;
        }
        if (expectedEnumValues.length() != observedEnumValues.length) {
            Assertions.fail((String)("The enum '" + expectedClassName + "' does not contain all the expected enum values. Make sure to implement the missing enums."));
            return;
        }
        for (int i = 0; i < expectedEnumValues.length(); ++i) {
            String expectedEnumValue = expectedEnumValues.getString(i);
            boolean enumValueExists = false;
            for (Object observedEnumValue : observedEnumValues) {
                if (!expectedEnumValue.equals(((Enum)observedEnumValue).name())) continue;
                enumValueExists = true;
                break;
            }
            if (enumValueExists) continue;
            Assertions.fail((String)("The class '" + expectedClassName + "' does not include the enum value: " + expectedEnumValue + ". Make sure to implement it as expected."));
        }
    }
}

