/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.ConfigurationUtils;
import de.tum.in.test.api.internal.PrivilegedException;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReportingUtils.class);

    private ReportingUtils() {
    }

    public static <T> T doProceedAndPostProcess(InvocationInterceptor.Invocation<T> invocation, TestContext context) throws Throwable {
        try {
            return (T)invocation.proceed();
        }
        catch (Throwable t) {
            throw ReportingUtils.processThrowable(t, context);
        }
    }

    public static Throwable processThrowable(Throwable t, TestContext context) {
        Optional<String> nonprivilegedFailureMessage = ConfigurationUtils.getNonprivilegedFailureMessage(context);
        if (nonprivilegedFailureMessage.isPresent()) {
            return ReportingUtils.processThrowablePrivilegedOnly(t, nonprivilegedFailureMessage.get());
        }
        return ReportingUtils.processThrowableRegularly(t);
    }

    private static Throwable processThrowableRegularly(Throwable t) {
        return ReportingUtils.trySanitizeThrowable(t, ReportingUtils::transformMessage);
    }

    private static Throwable processThrowablePrivilegedOnly(Throwable t, String nonprivilegedFailureMessage) {
        if (t instanceof PrivilegedException) {
            return ReportingUtils.trySanitizeThrowable(t, ReportingUtils::transformMessage);
        }
        return new AssertionError((Object)nonprivilegedFailureMessage);
    }

    private static Throwable trySanitizeThrowable(Throwable t, MessageTransformer messageTransformer) {
        String name = "unknown";
        try {
            name = t.getClass().getName();
            return ThrowableSanitizer.sanitize(t, messageTransformer);
        }
        catch (Throwable sanitizationError) {
            return ReportingUtils.handleSanitizationFailure(name, sanitizationError);
        }
    }

    private static String transformMessage(ThrowableInfo info) {
        if (!AssertionError.class.isAssignableFrom(info.getClass())) {
            ReportingUtils.addStackframeInfoToMessage(info);
        }
        return info.getMessage();
    }

    private static Throwable handleSanitizationFailure(String name, Throwable error) {
        String info = BlacklistedInvoker.invokeOrElse(error::toString, () -> error.getClass().toString());
        LOG.error("Sanitization failed for {} with error {}", (Object)name, (Object)info);
        return new SecurityException(Messages.formatLocalized("sanitization.sanitization_failure", name, info));
    }

    private static void addStackframeInfoToMessage(ThrowableInfo info) {
        StackTraceElement[] stackTrace = info.getStackTrace();
        Optional<StackTraceElement> first = ArtemisSecurityManager.firstNonWhitelisted(stackTrace);
        if (first.isPresent()) {
            String call = first.get().toString();
            info.setMessage(Objects.toString(info.getMessage(), "") + "\n" + Messages.formatLocalized("reporting.problem_location_hint", call));
        }
    }

    static {
        ThrowableSanitizer.sanitize(null);
    }
}

