/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.structural.StructuralTestProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;

public abstract class ConstructorTestProvider
extends StructuralTestProvider {
    protected DynamicContainer generateTestsForAllClasses() throws URISyntaxException {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        if (structureOracleJSON == null) {
            Assertions.fail((String)"The ConstructorTest can only run if the structural oracle (test.json) is present. If you do not provide it, delete ConstructorTest.java!");
        }
        for (int i = 0; i < structureOracleJSON.length(); ++i) {
            JSONObject expectedClassJSON = structureOracleJSON.getJSONObject(i);
            if (!expectedClassJSON.has("class") || !expectedClassJSON.has("constructors")) continue;
            JSONObject expectedClassPropertiesJSON = expectedClassJSON.getJSONObject("class");
            String expectedClassName = expectedClassPropertiesJSON.getString("name");
            String expectedPackageName = expectedClassPropertiesJSON.getString("package");
            StructuralTestProvider.ExpectedClassStructure expectedClassStructure = new StructuralTestProvider.ExpectedClassStructure(expectedClassName, expectedPackageName, expectedClassJSON);
            tests.add(DynamicTest.dynamicTest((String)("testConstructors[" + expectedClassName + "]"), () -> ConstructorTestProvider.testConstructors(expectedClassStructure)));
        }
        if (tests.isEmpty()) {
            Assertions.fail((String)"No tests for constructors available in the structural oracle (test.json). Either provide constructor information or delete ConstructorTest.java!");
        }
        return DynamicContainer.dynamicContainer((String)this.getClass().getName(), (URI)new URI(this.getClass().getName()), tests.stream());
    }

    protected static void testConstructors(StructuralTestProvider.ExpectedClassStructure expectedClassStructure) {
        String expectedClassName = expectedClassStructure.getExpectedClassName();
        Class<?> observedClass = ConstructorTestProvider.findClassForTestType(expectedClassStructure, "constructor");
        if (observedClass == null) {
            Assertions.fail((String)("The class " + expectedClassName + " was not found for constructor test"));
            return;
        }
        if (expectedClassStructure.hasProperty("constructors")) {
            JSONArray expectedConstructors = expectedClassStructure.getPropertyAsJsonArray("constructors");
            ConstructorTestProvider.checkConstructors(expectedClassName, observedClass, expectedConstructors);
        }
    }

    protected static void checkConstructors(String expectedClassName, Class<?> observedClass, JSONArray expectedConstructors) {
        for (int i = 0; i < expectedConstructors.length(); ++i) {
            JSONObject expectedConstructor = expectedConstructors.getJSONObject(i);
            JSONArray expectedParameters = ConstructorTestProvider.getExpectedJsonProperty(expectedConstructor, "parameters");
            JSONArray expectedModifiers = ConstructorTestProvider.getExpectedJsonProperty(expectedConstructor, "modifiers");
            JSONArray expectedAnnotations = ConstructorTestProvider.getExpectedJsonProperty(expectedConstructor, "annotations");
            boolean parametersAreRight = false;
            boolean modifiersAreRight = false;
            boolean annotationsAreRight = false;
            for (Constructor<?> observedConstructor : observedClass.getDeclaredConstructors()) {
                Class<?>[] observedParameters = observedConstructor.getParameterTypes();
                String[] observedModifiers = Modifier.toString(observedConstructor.getModifiers()).split(" ");
                Annotation[] observedAnnotations = observedConstructor.getAnnotations();
                parametersAreRight = ConstructorTestProvider.checkParameters(observedParameters, expectedParameters);
                modifiersAreRight = ConstructorTestProvider.checkModifiers(observedModifiers, expectedModifiers);
                annotationsAreRight = ConstructorTestProvider.checkAnnotations(observedAnnotations, expectedAnnotations);
                if (parametersAreRight && modifiersAreRight && annotationsAreRight) break;
            }
            ConstructorTestProvider.checkConstructorCorrectness(expectedClassName, expectedParameters, parametersAreRight, modifiersAreRight, annotationsAreRight);
        }
    }

    private static void checkConstructorCorrectness(String expectedClassName, JSONArray expectedParameters, boolean parametersAreCorrect, boolean modifiersAreCorrect, boolean annotationsAreCorrect) {
        String expectedConstructorInformation = "the expected constructor of the class '" + expectedClassName + "' with " + (String)(expectedParameters.length() == 0 ? "no parameters" : "the parameters: " + expectedParameters.toString());
        if (!parametersAreCorrect) {
            Assertions.fail((String)("The parameters of " + expectedConstructorInformation + " are not implemented as expected."));
        }
        if (!modifiersAreCorrect) {
            Assertions.fail((String)("The access modifiers of " + expectedConstructorInformation + " are not implemented as expected."));
        }
        if (!annotationsAreCorrect) {
            Assertions.fail((String)("The annotation(s) of " + expectedConstructorInformation + " are not implemented as expected."));
        }
    }
}

