/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.exception.ParserException;
import de.tum.in.ase.parser.strategy.ParserContext;
import de.tum.in.ase.parser.utils.FileUtils;
import de.tum.in.ase.parser.utils.ReportUtils;
import java.io.File;

public class ReportParser {
    private static final int STATIC_CODE_ANALYSIS_REPORT_FILESIZE_LIMIT_IN_MB = 1;

    public String transformToJSONReport(File file) throws ParserException {
        try {
            Report report = this.transformToReport(file);
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)report);
        }
        catch (Exception e) {
            throw new ParserException(e.getMessage(), e);
        }
    }

    public Report transformToReport(File file) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("File must not be null");
            }
            if (!FileUtils.getExtension(file).equals("xml")) {
                throw new IllegalArgumentException("File must be xml format");
            }
            if (FileUtils.isFilesizeGreaterThan(file, 1L)) {
                return ReportUtils.createFileTooLargeReport(file.getName());
            }
            ParserContext context = new ParserContext();
            return context.getReport(file);
        }
        catch (Exception e) {
            return ReportUtils.createErrorReport(file != null ? file.getName() : "", e);
        }
    }
}

