/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.utils.XmlUtils;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CheckstyleFormatParser
implements ParserStrategy {
    protected static final String FILE_TAG = "file";
    protected static final String FILE_ATT_NAME = "name";
    protected static final String ERROR_ATT_SOURCE = "source";
    protected static final String ERROR_ATT_SEVERITY = "severity";
    protected static final String ERROR_ATT_MESSAGE = "message";
    protected static final String ERROR_ATT_LINENUMBER = "line";
    protected static final String ERROR_ATT_COLUMN = "column";

    protected static String getProgrammingLanguage(String path) {
        String extension = path.substring(path.lastIndexOf("."));
        return extension.substring(1);
    }

    protected void extractIssues(Document doc, Report report) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Element root = doc.getDocumentElement();
        for (Element fileElement : XmlUtils.getChildElements(root, FILE_TAG)) {
            String unixPath = ParserUtils.transformToUnixPath(fileElement.getAttribute(FILE_ATT_NAME));
            for (Element errorElement : XmlUtils.getChildElements(fileElement)) {
                Issue issue = new Issue(unixPath);
                String errorSource = errorElement.getAttribute(ERROR_ATT_SOURCE);
                this.extractRuleAndCategory(issue, errorSource);
                issue.setPriority(errorElement.getAttribute(ERROR_ATT_SEVERITY));
                issue.setMessage(errorElement.getAttribute(ERROR_ATT_MESSAGE));
                int startLine = ParserUtils.extractInt(errorElement, ERROR_ATT_LINENUMBER);
                issue.setStartLine(startLine);
                issue.setEndLine(startLine);
                int startColumn = ParserUtils.extractInt(errorElement, ERROR_ATT_COLUMN);
                issue.setStartColumn(startColumn);
                issue.setEndColumn(startColumn);
                issues.add(issue);
            }
        }
        report.setIssues(issues);
    }

    protected abstract void extractRuleAndCategory(Issue var1, String var2);
}

