/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.CheckstyleFormatParser;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import org.w3c.dom.Document;

class CheckstyleParser
extends CheckstyleFormatParser {
    private static final String CATEGORY_DELIMITER = "checks";
    private static final String CATEGORY_MISCELLANEOUS = "miscellaneous";

    CheckstyleParser() {
    }

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.CHECKSTYLE);
        this.extractIssues(doc, report);
        return report;
    }

    @Override
    protected void extractRuleAndCategory(Issue issue, String errorSource) {
        String[] errorSourceSegments = errorSource.split("\\.");
        int noOfSegments = errorSourceSegments.length;
        if (noOfSegments < 2) {
            issue.setCategory(errorSource);
            return;
        }
        String rule = errorSourceSegments[noOfSegments - 1];
        String category = errorSourceSegments[noOfSegments - 2];
        if (category.equals(CATEGORY_DELIMITER)) {
            category = CATEGORY_MISCELLANEOUS;
        }
        issue.setRule(rule);
        issue.setCategory(category);
    }
}

