/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GCCParser
implements ParserStrategy {
    private static final int SEGMENTS_COUNT = 2;
    private static final int HEADER_SEGMENT_POS = 0;
    private static final int BODY_SEGMENT_POS = 1;
    private static final int FILE_POS = 1;
    private static final int ROW_POS = 2;
    private static final int COLUMN_POS = 3;
    private static final int TYPE_POS = 4;
    private static final int DESCRIPTION_POS = 5;
    private static final int ERROR_POS = 6;
    private static final Map<String, String> categories = new HashMap<String, String>();
    private static final String ANALYZER_PREFIX = "[-Wanalyzer";
    private static final String MEMORY = "Memory";
    private static final String BAD_PRACTICE = "BadPractice";
    private static final String SECURITY = "Security";
    private static final String UNDEFINED_BEHAVIOR = "UndefinedBehavior";
    private static final String MISC = "Misc";
    private static final String HEADER_REGEX = "([^:^\\n]+):(\\d+):(\\d+):\\s(\\w+\\s*\\w*):\\s(.+)(\\[.+])";
    private static final String DELIM_REGEX = "(?=(\\n([^:^\\n]+):(\\d)+:(\\d)+:(.)+:(.)+))";

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.GCC);
        this.extractIssues(doc, report);
        return report;
    }

    private void extractIssues(Document doc, Report report) {
        Element gccLog = doc.getDocumentElement();
        String[] logItems = gccLog.getTextContent().split(DELIM_REGEX);
        Pattern pattern = Pattern.compile(HEADER_REGEX);
        Matcher matcher = pattern.matcher("");
        this.initCategoryMapping();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (String entry : logItems) {
            String[] segments = entry.substring(1).split("\n", 2);
            if (segments.length < 2) continue;
            String header = segments[0];
            String body = segments[1];
            matcher.reset(header);
            if (!matcher.find()) continue;
            String filename = matcher.group(1).trim();
            Integer row = Integer.parseInt(matcher.group(2));
            Integer col = Integer.parseInt(matcher.group(3));
            String type = matcher.group(4);
            String description = matcher.group(5);
            String warningName = matcher.group(6);
            if (warningName == null) continue;
            String message = warningName + ": " + description + "\n" + body;
            Issue issue = new Issue(null);
            issue.setMessage(message);
            issue.setFilePath(filename);
            issue.setStartLine(row);
            issue.setEndLine(row);
            issue.setStartColumn(col);
            issue.setEndColumn(col);
            issue.setRule(warningName);
            issue.setPriority(type);
            boolean isAnalyzerIssue = warningName.startsWith(ANALYZER_PREFIX);
            if (isAnalyzerIssue) {
                String category = categories.get(warningName);
                issue.setCategory(category);
            } else {
                issue.setCategory(MISC);
            }
            issues.add(issue);
        }
        report.setIssues(issues);
    }

    private void initCategoryMapping() {
        categories.put("[-Wanalyzer-free-of-non-heap]", MEMORY);
        categories.put("[-Wanalyzer-malloc-leak]", MEMORY);
        categories.put("[-Wanalyzer-file-leak]", MEMORY);
        categories.put("[-Wanalyzer-mismatching-deallocation]", MEMORY);
        categories.put("[-Wanalyzer-double-free]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-null-argument]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-use-after-free]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-use-of-uninitialized-value]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-write-to-const]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-write-to-string-literal]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-possible-null-argument]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-possible-null-dereference]", UNDEFINED_BEHAVIOR);
        categories.put("[-Wanalyzer-double-fclose]", BAD_PRACTICE);
        categories.put("[-Wanalyzer-too-complex]", BAD_PRACTICE);
        categories.put("[-Wanalyzer-stale-setjmp-buffer]", BAD_PRACTICE);
        categories.put("[-Wanalyzer-exposure-through-output-file]", SECURITY);
        categories.put("[-Wanalyzer-unsafe-call-within-signal-handler]", SECURITY);
        categories.put("[-Wanalyzer-use-of-pointer-in-stale-stack-frame]", SECURITY);
        categories.put("[-Wanalyzer-tainted-array-index]", SECURITY);
    }
}

