/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import de.tum.in.ase.parser.utils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class PMDCPDParser
implements ParserStrategy {
    private static final String CPD_CATEGORY = "Copy/Paste Detection";
    private static final String DUPLICATION_TAG = "duplication";
    private static final String DUPLICATION_ATT_LINES = "lines";
    private static final String FILE_TAG = "file";
    private static final String FILE_ATT_PATH = "path";
    private static final String FILE_ATT_STARTLINE = "line";
    private static final String FILE_ATT_ENDLINE = "endline";
    private static final String FILE_ATT_STARTCOLUMN = "column";
    private static final String FILE_ATT_ENDCOLUMN = "endcolumn";

    PMDCPDParser() {
    }

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.PMD_CPD);
        ArrayList<Issue> allIssues = new ArrayList<Issue>();
        Element root = doc.getDocumentElement();
        for (Element duplication : XmlUtils.getChildElements(root, DUPLICATION_TAG)) {
            ArrayList<Issue> issuesForDuplication = new ArrayList<Issue>();
            int lines = ParserUtils.extractInt(duplication, DUPLICATION_ATT_LINES);
            for (Element file : XmlUtils.getChildElements(duplication, FILE_TAG)) {
                Issue issue2 = new Issue();
                issue2.setCategory(CPD_CATEGORY);
                issue2.setRule(CPD_CATEGORY);
                String unixPath = ParserUtils.transformToUnixPath(file.getAttribute(FILE_ATT_PATH));
                issue2.setFilePath(unixPath);
                issue2.setStartLine(ParserUtils.extractInt(file, FILE_ATT_STARTLINE));
                issue2.setEndLine(ParserUtils.extractInt(file, FILE_ATT_ENDLINE));
                issue2.setStartColumn(ParserUtils.extractInt(file, FILE_ATT_STARTCOLUMN));
                issue2.setEndColumn(ParserUtils.extractInt(file, FILE_ATT_ENDCOLUMN));
                issuesForDuplication.add(issue2);
            }
            String message = this.createMessage(lines, issuesForDuplication);
            issuesForDuplication.forEach(issue -> issue.setMessage(message));
            allIssues.addAll(issuesForDuplication);
        }
        report.setIssues(allIssues);
        return report;
    }

    private String createMessage(int duplicatedLines, List<Issue> issues) {
        StringBuilder builder = new StringBuilder();
        builder.append("Code duplication of ").append(duplicatedLines).append(" lines in the following files:");
        int counter = 1;
        for (Issue issue : issues) {
            String filename = this.extractFilename(issue.getFilePath());
            builder.append("\n").append(counter).append(". ").append(filename).append(":");
            builder.append(issue.getStartLine()).append("-").append(issue.getEndLine());
            ++counter;
        }
        return builder.toString();
    }

    private String extractFilename(String unixPath) {
        return new File(unixPath).getName();
    }
}

