/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import de.tum.in.ase.parser.utils.XmlUtils;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class PMDParser
implements ParserStrategy {
    private static final String FILE_TAG = "file";
    private static final String FILE_ATT_NAME = "name";
    private static final String VIOLATION_ATT_RULE = "rule";
    private static final String VIOLATION_ATT_RULESET = "ruleset";
    private static final String VIOLATION_ATT_PRIORITY = "priority";
    private static final String VIOLATION_ATT_BEGINLINE = "beginline";
    private static final String VIOLATION_ATT_ENDLINE = "endline";
    private static final String VIOLATION_ATT_BEGINCOLUMN = "begincolumn";
    private static final String VIOLATION_ATT_ENDCOLUMN = "endcolumn";

    PMDParser() {
    }

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.PMD);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Element root = doc.getDocumentElement();
        for (Element fileElement : XmlUtils.getChildElements(root, FILE_TAG)) {
            String unixPath = ParserUtils.transformToUnixPath(fileElement.getAttribute(FILE_ATT_NAME));
            for (Element violationElement : XmlUtils.getChildElements(fileElement)) {
                Issue issue = new Issue(unixPath);
                issue.setRule(violationElement.getAttribute(VIOLATION_ATT_RULE));
                issue.setCategory(violationElement.getAttribute(VIOLATION_ATT_RULESET));
                issue.setPriority(violationElement.getAttribute(VIOLATION_ATT_PRIORITY));
                issue.setStartLine(ParserUtils.extractInt(violationElement, VIOLATION_ATT_BEGINLINE));
                issue.setEndLine(ParserUtils.extractInt(violationElement, VIOLATION_ATT_ENDLINE));
                issue.setStartColumn(ParserUtils.extractInt(violationElement, VIOLATION_ATT_BEGINCOLUMN));
                issue.setEndColumn(ParserUtils.extractInt(violationElement, VIOLATION_ATT_ENDCOLUMN));
                issue.setMessage(ParserUtils.stripNewLinesAndWhitespace(violationElement.getTextContent()));
                issues.add(issue);
            }
        }
        report.setIssues(issues);
        return report;
    }
}

