/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.exception.UnsupportedToolException;
import de.tum.in.ase.parser.strategy.CheckstyleFormatParser;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import de.tum.in.ase.parser.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ParserPolicy {
    ParserPolicy() {
    }

    public ParserStrategy configure(Document document) {
        String rootTag = document.getDocumentElement().getNodeName();
        StaticCodeAnalysisTool tool = StaticCodeAnalysisTool.getToolByIdentifierTag(rootTag).orElseThrow(() -> new UnsupportedToolException("Tool for identifying tag " + rootTag + " not found"));
        if (tool.getIdentifyingTag().equals("checkstyle")) {
            return this.getCorrectCheckstyleParser(document);
        }
        return tool.getStrategy();
    }

    private ParserStrategy getCorrectCheckstyleParser(Document document) {
        Element root = document.getDocumentElement();
        return XmlUtils.getFirstChild(root, "file").map(fileElement -> {
            String nameValue = fileElement.getAttribute("name");
            String unixPath = ParserUtils.transformToUnixPath(nameValue);
            return CheckstyleFormatParser.getProgrammingLanguage(unixPath);
        }).map(language -> {
            if (language.equals("swift")) {
                return StaticCodeAnalysisTool.SWIFTLINT.getStrategy();
            }
            return StaticCodeAnalysisTool.CHECKSTYLE.getStrategy();
        }).orElse(StaticCodeAnalysisTool.CHECKSTYLE.getStrategy());
    }
}

