/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import de.tum.in.ase.parser.utils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SpotbugsParser
implements ParserStrategy {
    private static final String PROJECT_ELEMENT = "Project";
    private static final String SOURCE_DIRECTORY_ELEMENT = "SrcDir";
    private static final String BUGINSTANCE_ELEMENT = "BugInstance";
    private static final String BUGINSTANCE_ATT_TYPE = "type";
    private static final String BUGINSTANCE_ATT_CATEGORY = "category";
    private static final String BUGINSTANCE_ATT_PRIORITY = "priority";
    private static final String SOURCELINE_ELEMENT = "SourceLine";
    private static final String SOURCELINE_ATT_SOURCEPATH = "sourcepath";
    private static final String SOURCELINE_ATT_START = "start";
    private static final String SOURCELINE_ATT_END = "end";
    private static final String LONGMESSAGE_ELEMENT = "LongMessage";

    SpotbugsParser() {
    }

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.SPOTBUGS);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Element root = doc.getDocumentElement();
        String sourceDirectory = XmlUtils.getFirstChild(root, PROJECT_ELEMENT).flatMap(p -> XmlUtils.getFirstChild(p, SOURCE_DIRECTORY_ELEMENT)).map(Node::getTextContent).map(srcDir -> {
            if (!srcDir.endsWith(File.separator)) {
                return srcDir + File.separator;
            }
            return srcDir;
        }).orElse("");
        for (Element bugInstance : XmlUtils.getChildElements(root, BUGINSTANCE_ELEMENT)) {
            Issue issue = new Issue();
            issue.setRule(bugInstance.getAttribute(BUGINSTANCE_ATT_TYPE));
            issue.setCategory(bugInstance.getAttribute(BUGINSTANCE_ATT_CATEGORY));
            issue.setPriority(bugInstance.getAttribute(BUGINSTANCE_ATT_PRIORITY));
            XmlUtils.getFirstChild(bugInstance, SOURCELINE_ELEMENT).ifPresent(sourceLine -> {
                String unixPath = ParserUtils.transformToUnixPath(sourceDirectory + sourceLine.getAttribute(SOURCELINE_ATT_SOURCEPATH));
                issue.setFilePath(unixPath);
                issue.setStartLine(ParserUtils.extractInt(sourceLine, SOURCELINE_ATT_START));
                issue.setEndLine(ParserUtils.extractInt(sourceLine, SOURCELINE_ATT_END));
            });
            XmlUtils.getFirstChild(bugInstance, LONGMESSAGE_ELEMENT).ifPresent(longMessage -> issue.setMessage(ParserUtils.stripNewLinesAndWhitespace(longMessage.getTextContent())));
            issues.add(issue);
        }
        report.setIssues(issues);
        return report;
    }
}

