/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.strategy.CheckstyleParser;
import de.tum.in.ase.parser.strategy.GCCParser;
import de.tum.in.ase.parser.strategy.PMDCPDParser;
import de.tum.in.ase.parser.strategy.PMDParser;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.SpotbugsParser;
import de.tum.in.ase.parser.strategy.SwiftLintParser;
import java.util.Objects;
import java.util.Optional;

public enum StaticCodeAnalysisTool {
    SPOTBUGS("BugCollection", "spotbugsXml.xml", new SpotbugsParser()),
    CHECKSTYLE("checkstyle", "checkstyle-result.xml", new CheckstyleParser()),
    SWIFTLINT("checkstyle", "swiftlint-result.xml", new SwiftLintParser()),
    PMD("pmd", "pmd.xml", new PMDParser()),
    PMD_CPD("pmd-cpd", "cpd.xml", new PMDCPDParser()),
    GCC("root", "gcc.xml", new GCCParser());

    private final String identifierTag;
    private final String filename;
    private final ParserStrategy strategy;

    private StaticCodeAnalysisTool(String identifyingTag, String filename, ParserStrategy strategy) {
        this.identifierTag = identifyingTag;
        this.filename = filename;
        this.strategy = strategy;
    }

    public String getIdentifyingTag() {
        return this.identifierTag;
    }

    public String getFilename() {
        return this.filename;
    }

    public ParserStrategy getStrategy() {
        return this.strategy;
    }

    public static Optional<StaticCodeAnalysisTool> getToolByIdentifierTag(String identifierTag) {
        for (StaticCodeAnalysisTool tool : StaticCodeAnalysisTool.values()) {
            if (!Objects.equals(identifierTag, tool.getIdentifyingTag())) continue;
            return Optional.of(tool);
        }
        return Optional.empty();
    }

    public static Optional<StaticCodeAnalysisTool> getToolByFilename(String filename) {
        for (StaticCodeAnalysisTool tool : StaticCodeAnalysisTool.values()) {
            if (!Objects.equals(filename, tool.getFilename())) continue;
            return Optional.of(tool);
        }
        return Optional.empty();
    }
}

