/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.utils;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import java.util.ArrayList;
import java.util.List;

public class ReportUtils {
    public static Report createFileTooLargeReport(String filename) {
        StaticCodeAnalysisTool tool = StaticCodeAnalysisTool.getToolByFilename(filename).orElse(null);
        Report report = new Report(tool);
        Issue issue = new Issue();
        issue.setCategory("miscellaneous");
        issue.setMessage(String.format("There are too many issues found in the %s tool.", new Object[]{tool}));
        issue.setFilePath(filename);
        issue.setStartLine(1);
        issue.setRule("TooManyIssues");
        report.setIssues(ReportUtils.listOf(issue));
        return report;
    }

    public static Report createErrorReport(String filename, Exception exception) {
        StaticCodeAnalysisTool tool = StaticCodeAnalysisTool.getToolByFilename(filename).orElse(null);
        Report report = new Report(tool);
        Issue issue = new Issue();
        issue.setCategory("miscellaneous");
        issue.setMessage(String.format("An exception occurred during parsing the report for %s. Exception: %s", tool != null ? tool : "file " + filename, exception));
        issue.setFilePath(filename);
        issue.setStartLine(1);
        issue.setRule("ExceptionDuringParsing");
        report.setIssues(ReportUtils.listOf(issue));
        return report;
    }

    private static List<Issue> listOf(Issue issue) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        issues.add(issue);
        return issues;
    }
}

