/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        domFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        domFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        domFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        domFactory.setXIncludeAware(false);
        domFactory.setExpandEntityReferences(false);
        return domFactory.newDocumentBuilder();
    }

    public static Optional<Element> getFirstChild(Element parent, String name) {
        Iterator<Element> iterator = XmlUtils.getChildElements(parent, name).iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    public static Iterable<Element> getChildElements(Element parent) {
        return XmlUtils.getChildElements(parent, null);
    }

    public static Iterable<Element> getChildElements(final Element parent, final String name) {
        return () -> new Iterator<Element>(){
            final NodeList children;
            int index;
            {
                this.children = parent.getElementsByTagName(name != null ? name : "*");
                this.index = this.skipIndirectChildren();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.children.getLength();
            }

            @Override
            public Element next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Element result = (Element)this.children.item(this.index++);
                this.skipIndirectChildren();
                return result;
            }

            private int skipIndirectChildren() {
                while (this.hasNext() && !this.children.item(this.index).getParentNode().isEqualNode(parent)) {
                    ++this.index;
                }
                return this.index;
            }
        };
    }
}

