/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Album;
import de.umass.lastfm.Caller;
import de.umass.lastfm.Event;
import de.umass.lastfm.Image;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.MusicEntry;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Shout;
import de.umass.lastfm.Tag;
import de.umass.lastfm.Track;
import de.umass.lastfm.User;
import de.umass.util.MapUtilities;
import de.umass.util.StringUtilities;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artist
extends MusicEntry {
    static final ItemFactory<Artist> FACTORY = new ArtistFactory();
    private Collection<Artist> similar = new ArrayList<Artist>();

    protected Artist(String name, String url) {
        super(name, url);
    }

    protected Artist(String name, String url, String mbid, int playcount, int listeners, boolean streamable) {
        super(name, url, mbid, playcount, listeners, streamable);
    }

    public Collection<Artist> getSimilar() {
        return this.similar;
    }

    public static Artist getInfo(String artistOrMbid, String apiKey) {
        return Artist.getInfo(artistOrMbid, null, null, apiKey);
    }

    public static Artist getInfo(String artistOrMbid, String username, String apiKey) {
        return Artist.getInfo(artistOrMbid, null, username, apiKey);
    }

    public static Artist getInfo(String artistOrMbid, Locale locale, String username, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(artistOrMbid)) {
            params.put("mbid", artistOrMbid);
        } else {
            params.put("artist", artistOrMbid);
        }
        if (locale != null && locale.getLanguage().length() != 0) {
            params.put("lang", locale.getLanguage());
        }
        MapUtilities.nullSafePut(params, "username", username);
        Result result = Caller.getInstance().call("artist.getInfo", apiKey, params);
        return ResponseBuilder.buildItem(result, Artist.class);
    }

    public static Collection<Artist> getSimilar(String artist, String apiKey) {
        return Artist.getSimilar(artist, 100, apiKey);
    }

    public static Collection<Artist> getSimilar(String artist, int limit, String apiKey) {
        Result result = Caller.getInstance().call("artist.getSimilar", apiKey, "artist", artist, "limit", String.valueOf(limit));
        return ResponseBuilder.buildCollection(result, Artist.class);
    }

    public static Collection<Artist> search(String name, String apiKey) {
        Result result = Caller.getInstance().call("artist.search", apiKey, "artist", name);
        List<DomElement> children = result.getContentElement().getChild("artistmatches").getChildren("artist");
        ArrayList<Artist> list = new ArrayList<Artist>(children.size());
        for (DomElement c : children) {
            list.add(FACTORY.createItemFromElement(c));
        }
        return list;
    }

    public static Collection<Album> getTopAlbums(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopAlbums", apiKey, "artist", artist);
        return ResponseBuilder.buildCollection(result, Album.class);
    }

    public static Collection<User> getTopFans(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopFans", apiKey, "artist", artist);
        return ResponseBuilder.buildCollection(result, User.class);
    }

    public static Collection<Tag> getTopTags(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopTags", apiKey, "artist", artist);
        return ResponseBuilder.buildCollection(result, Tag.class);
    }

    public static Collection<Track> getTopTracks(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopTracks", apiKey, "artist", artist);
        return ResponseBuilder.buildCollection(result, Track.class);
    }

    public static Result addTags(String artist, String tags, Session session) {
        return Caller.getInstance().call("artist.addTags", session, "artist", artist, "tags", tags);
    }

    public static Result removeTag(String artist, String tag, Session session) {
        return Caller.getInstance().call("artist.removeTag", session, "artist", artist, "tag", tag);
    }

    public static Result share(String artist, String recipients, String message, Session session) {
        return Caller.getInstance().call("artist.share", session, "artist", artist, "recipient", recipients, "message", message);
    }

    public static Collection<String> getTags(String artist, Session session) {
        Result result = Caller.getInstance().call("artist.getTags", session, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static PaginatedResult<Event> getEvents(String artistOrMbid, String apiKey) {
        return Artist.getEvents(artistOrMbid, false, -1, -1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String artistOrMbid, boolean festivalsOnly, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(artistOrMbid)) {
            params.put("mbid", artistOrMbid);
        } else {
            params.put("artist", artistOrMbid);
        }
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        if (festivalsOnly) {
            params.put("festivalsonly", "1");
        }
        Result result = Caller.getInstance().call("artist.getEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static PaginatedResult<Event> getPastEvents(String artistOrMbid, String apiKey) {
        return Artist.getPastEvents(artistOrMbid, false, -1, -1, apiKey);
    }

    public static PaginatedResult<Event> getPastEvents(String artistOrMbid, boolean festivalsOnly, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(artistOrMbid)) {
            params.put("mbid", artistOrMbid);
        } else {
            params.put("artist", artistOrMbid);
        }
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        if (festivalsOnly) {
            params.put("festivalsonly", "1");
        }
        Result result = Caller.getInstance().call("artist.getPastEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static PaginatedResult<Image> getImages(String artistOrMbid, String apiKey) {
        return Artist.getImages(artistOrMbid, -1, -1, apiKey);
    }

    public static PaginatedResult<Image> getImages(String artistOrMbid, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(artistOrMbid)) {
            params.put("mbid", artistOrMbid);
        } else {
            params.put("artist", artistOrMbid);
        }
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call("artist.getImages", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Image.class);
    }

    public static Result shout(String artist, String message, Session session) {
        return Caller.getInstance().call("artist.shout", session, "artist", artist, "message", message);
    }

    public static Artist getCorrection(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getCorrection", apiKey, "artist", artist);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement correctionElement = result.getContentElement().getChild("correction");
        if (correctionElement == null) {
            return new Artist(artist, null);
        }
        DomElement artistElem = correctionElement.getChild("artist");
        return FACTORY.createItemFromElement(artistElem);
    }

    public static PaginatedResult<Shout> getShouts(String artistOrMbid, String apiKey) {
        return Artist.getShouts(artistOrMbid, -1, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String artistOrMbid, int page, String apiKey) {
        return Artist.getShouts(artistOrMbid, page, -1, apiKey);
    }

    public static PaginatedResult<Shout> getShouts(String artistOrMbid, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(artistOrMbid)) {
            params.put("mbid", artistOrMbid);
        } else {
            params.put("artist", artistOrMbid);
        }
        MapUtilities.nullSafePut(params, "limit", limit);
        MapUtilities.nullSafePut(params, "page", page);
        Result result = Caller.getInstance().call("artist.getShouts", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Shout.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtistFactory
    implements ItemFactory<Artist> {
        private ArtistFactory() {
        }

        @Override
        public Artist createItemFromElement(DomElement element) {
            Artist artist = new Artist(null, null);
            MusicEntry.loadStandardInfo(artist, element);
            DomElement similar = element.getChild("similar");
            if (similar != null) {
                List<DomElement> children = similar.getChildren("artist");
                for (DomElement child : children) {
                    artist.similar.add(this.createItemFromElement(child));
                }
            }
            return artist;
        }
    }
}

