/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Authenticator;
import de.umass.lastfm.CallException;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.cache.Cache;
import de.umass.lastfm.cache.FileSystemCache;
import de.umass.util.StringUtilities;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Caller {
    private static final String PARAM_API_KEY = "api_key";
    private static final String PARAM_METHOD = "method";
    private static final String DEFAULT_API_ROOT = "http://ws.audioscrobbler.com/2.0/";
    private static final Caller instance = new Caller();
    private final Logger log = Logger.getLogger("de.umass.lastfm.Caller");
    private String apiRootUrl = "http://ws.audioscrobbler.com/2.0/";
    private Proxy proxy;
    private String userAgent = "tst";
    private boolean debugMode = false;
    private Cache cache = new FileSystemCache();
    private Result lastResult;

    private Caller() {
    }

    public static Caller getInstance() {
        return instance;
    }

    public void setApiRootUrl(String apiRootUrl) {
        this.apiRootUrl = apiRootUrl;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        this.log.setLevel(debugMode ? Level.ALL : Level.OFF);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public Logger getLogger() {
        return this.log;
    }

    public Result getLastResult() {
        return this.lastResult;
    }

    public Result call(String method, String apiKey, String ... params) throws CallException {
        return this.call(method, apiKey, StringUtilities.map(params));
    }

    public Result call(String method, String apiKey, Map<String, String> params) throws CallException {
        return this.call(method, apiKey, params, null);
    }

    public Result call(String method, Session session, String ... params) {
        return this.call(method, session.getApiKey(), StringUtilities.map(params), session);
    }

    public Result call(String method, Session session, Map<String, String> params) {
        return this.call(method, session.getApiKey(), params, session);
    }

    private Result call(String method, String apiKey, Map<String, String> params, Session session) {
        params = new HashMap<String, String>(params);
        InputStream inputStream = null;
        String cacheEntryName = Cache.createCacheEntryName(method, params);
        if (session == null && this.cache != null) {
            inputStream = this.getStreamFromCache(cacheEntryName);
        }
        if (inputStream == null) {
            params.put(PARAM_API_KEY, apiKey);
            if (session != null) {
                params.put("sk", session.getKey());
                params.put("api_sig", Authenticator.createSignature(method, params, session.getSecret()));
            }
            try {
                HttpURLConnection urlConnection = this.openPostConnection(method, params);
                inputStream = this.getInputStreamFromConnection(urlConnection);
                if (inputStream == null) {
                    this.lastResult = Result.createHttpErrorResult(urlConnection.getResponseCode(), urlConnection.getResponseMessage());
                    return this.lastResult;
                }
                if (this.cache != null) {
                    long expires = urlConnection.getHeaderFieldDate("Expires", -1L);
                    if (expires == -1L) {
                        expires = this.cache.findExpirationDate(method, params);
                    }
                    if (expires != -1L) {
                        this.cache.store(cacheEntryName, inputStream, expires);
                        inputStream = this.cache.load(cacheEntryName);
                        if (inputStream == null) {
                            throw new CallException("Caching/Reloading failed");
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CallException(e);
            }
        }
        try {
            Result result = this.createResultFromInputStream(inputStream);
            if (!result.isSuccessful()) {
                this.log.warning(String.format("API call failed with result: %s%n", result));
                if (this.cache != null) {
                    this.cache.remove(cacheEntryName);
                }
            }
            this.lastResult = result;
            return result;
        }
        catch (IOException e) {
            throw new CallException(e);
        }
        catch (SAXException e) {
            throw new CallException(e);
        }
    }

    private InputStream getStreamFromCache(String cacheEntryName) {
        if (this.cache != null && this.cache.contains(cacheEntryName) && !this.cache.isExpired(cacheEntryName)) {
            return this.cache.load(cacheEntryName);
        }
        return null;
    }

    public HttpURLConnection openConnection(String url) throws IOException {
        this.log.info("Open connection: " + url);
        URL u = new URL(url);
        HttpURLConnection urlConnection = this.proxy != null ? (HttpURLConnection)u.openConnection(this.proxy) : (HttpURLConnection)u.openConnection();
        urlConnection.setRequestProperty("User-Agent", this.userAgent);
        return urlConnection;
    }

    private HttpURLConnection openPostConnection(String method, Map<String, String> params) throws IOException {
        HttpURLConnection urlConnection = this.openConnection(this.apiRootUrl);
        urlConnection.setRequestMethod("POST");
        urlConnection.setDoOutput(true);
        OutputStream outputStream = urlConnection.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        String post = this.buildPostBody(method, params, new String[0]);
        this.log.info("Post body: " + post);
        writer.write(post);
        writer.close();
        return urlConnection;
    }

    private InputStream getInputStreamFromConnection(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 403 || responseCode == 400) {
            return connection.getErrorStream();
        }
        if (responseCode == 200) {
            return connection.getInputStream();
        }
        return null;
    }

    private Result createResultFromInputStream(InputStream inputStream) throws SAXException, IOException {
        Result.Status status;
        Document document = this.newDocumentBuilder().parse(new InputSource(new InputStreamReader(inputStream, "UTF-8")));
        Element root = document.getDocumentElement();
        String statusString = root.getAttribute("status");
        Result.Status status2 = status = "ok".equals(statusString) ? Result.Status.OK : Result.Status.FAILED;
        if (status == Result.Status.FAILED) {
            Element errorElement = (Element)root.getElementsByTagName("error").item(0);
            int errorCode = Integer.parseInt(errorElement.getAttribute("code"));
            String message = errorElement.getTextContent();
            return Result.createRestErrorResult(errorCode, message);
        }
        return Result.createOkResult(document);
    }

    private DocumentBuilder newDocumentBuilder() {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            return builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildPostBody(String method, Map<String, String> params, String ... strings) {
        StringBuilder builder = new StringBuilder(100);
        builder.append("method=");
        builder.append(method);
        builder.append('&');
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(StringUtilities.encode(entry.getValue()));
            if (!it.hasNext() && strings.length <= 0) continue;
            builder.append('&');
        }
        int count = 0;
        for (String string : strings) {
            builder.append(count % 2 == 0 ? string : StringUtilities.encode(string));
            if (++count == strings.length) continue;
            if (count % 2 == 0) {
                builder.append('&');
                continue;
            }
            builder.append('=');
        }
        return builder.toString();
    }

    private String createSignature(Map<String, String> params, String secret) {
        TreeSet<String> sorted = new TreeSet<String>(params.keySet());
        StringBuilder builder = new StringBuilder(50);
        for (String s : sorted) {
            builder.append(s);
            builder.append(StringUtilities.encode(params.get(s)));
        }
        builder.append(secret);
        return StringUtilities.md5(builder.toString());
    }
}

