/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Artist;
import de.umass.lastfm.Caller;
import de.umass.lastfm.Chart;
import de.umass.lastfm.Event;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Track;
import de.umass.util.MapUtilities;
import de.umass.util.StringUtilities;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geo {
    private Geo() {
    }

    public static Collection<Event> getAllEvents(String location, String distance, String apiKey) {
        int total;
        ArrayList<Event> events = null;
        int page = 1;
        do {
            PaginatedResult<Event> result = Geo.getEvents(location, distance, page, apiKey);
            total = result.getTotalPages();
            Collection<Event> pageResults = result.getPageResults();
            if (events == null) {
                events = new ArrayList<Event>(total * pageResults.size());
            }
            for (Event artist : pageResults) {
                events.add(artist);
            }
        } while (++page <= total);
        return events;
    }

    public static PaginatedResult<Event> getEvents(String location, String distance, String apiKey) {
        return Geo.getEvents(location, distance, 1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String location, String distance, int page, String apiKey) {
        return Geo.getEvents(location, distance, page, -1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String location, String distance, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page));
        MapUtilities.nullSafePut(params, "location", location);
        MapUtilities.nullSafePut(params, "distance", distance);
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call("geo.getEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static PaginatedResult<Event> getEvents(double latitude, double longitude, int page, String apiKey) {
        return Geo.getEvents(latitude, longitude, page, -1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(double latitude, double longitude, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page));
        params.put("lat", String.valueOf(latitude));
        params.put("long", String.valueOf(longitude));
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call("geo.getEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static PaginatedResult<Event> getEvents(double latitude, double longitude, String distance, String apiKey) {
        return Geo.getEvents(latitude, longitude, distance, -1, -1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(double latitude, double longitude, String distance, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lat", String.valueOf(latitude));
        params.put("long", String.valueOf(longitude));
        params.put("distance", distance);
        MapUtilities.nullSafePut(params, "page", page);
        MapUtilities.nullSafePut(params, "limit", limit);
        Result result = Caller.getInstance().call("geo.getEvents", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Event.class);
    }

    public static Collection<Artist> getTopArtists(String country, String apiKey) {
        Result result = Caller.getInstance().call("geo.getTopArtists", apiKey, "country", country);
        return ResponseBuilder.buildCollection(result, Artist.class);
    }

    public static Collection<Track> getTopTracks(String country, String apiKey) {
        Result result = Caller.getInstance().call("geo.getTopTracks", apiKey, "country", country);
        return ResponseBuilder.buildCollection(result, Track.class);
    }

    public static Collection<Metro> getMetros(String apiKey) {
        return Geo.getMetros(null, apiKey);
    }

    public static Collection<Metro> getMetros(String country, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        MapUtilities.nullSafePut(params, "country", country);
        Result result = Caller.getInstance().call("geo.getMetros", apiKey, params);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        List<DomElement> children = result.getContentElement().getChildren("metro");
        ArrayList<Metro> metros = new ArrayList<Metro>(children.size());
        for (DomElement child : children) {
            metros.add(new Metro(child.getChildText("name"), child.getChildText("country")));
        }
        return metros;
    }

    public static LinkedHashMap<String, String> getMetroWeeklyChartList(String metro, String apiKey) {
        return Chart.getWeeklyChartList("geo.getMetroWeeklyChartList", "metro", metro, apiKey);
    }

    public static Chart<Artist> getMetroArtistChart(String country, String metro, String apiKey) {
        return Geo.getMetroArtistChart(country, metro, null, null, apiKey);
    }

    public static Chart<Artist> getMetroArtistChart(Metro metro, String start, String end, String apiKey) {
        return Geo.getMetroArtistChart(metro.getCountry(), metro.getName(), start, end, apiKey);
    }

    public static Chart<Artist> getMetroArtistChart(String country, String metro, String start, String end, String apiKey) {
        return Chart.getChart("geo.getMetroArtistChart", "artist", StringUtilities.map("country", country, "metro", metro), start, end, -1, apiKey);
    }

    public static Chart<Track> getMetroTrackChart(String country, String metro, String apiKey) {
        return Geo.getMetroTrackChart(country, metro, null, null, apiKey);
    }

    public static Chart<Track> getMetroTrackChart(Metro metro, String start, String end, String apiKey) {
        return Geo.getMetroTrackChart(metro.getCountry(), metro.getName(), start, end, apiKey);
    }

    public static Chart<Track> getMetroTrackChart(String country, String metro, String start, String end, String apiKey) {
        return Chart.getChart("geo.getMetroTrackChart", "track", StringUtilities.map("country", country, "metro", metro), start, end, -1, apiKey);
    }

    public static Chart<Artist> getMetroHypeArtistChart(String country, String metro, String apiKey) {
        return Geo.getMetroHypeArtistChart(country, metro, null, null, apiKey);
    }

    public static Chart<Artist> getMetroHypeArtistChart(Metro metro, String start, String end, String apiKey) {
        return Geo.getMetroHypeArtistChart(metro.getCountry(), metro.getName(), start, end, apiKey);
    }

    public static Chart<Artist> getMetroHypeArtistChart(String country, String metro, String start, String end, String apiKey) {
        return Chart.getChart("geo.getMetroHypeArtistChart", "artist", StringUtilities.map("country", country, "metro", metro), start, end, -1, apiKey);
    }

    public static Chart<Track> getMetroHypeTrackChart(String country, String metro, String apiKey) {
        return Geo.getMetroHypeTrackChart(country, metro, null, null, apiKey);
    }

    public static Chart<Track> getMetroHypeTrackChart(Metro metro, String start, String end, String apiKey) {
        return Geo.getMetroHypeTrackChart(metro.getCountry(), metro.getName(), start, end, apiKey);
    }

    public static Chart<Track> getMetroHypeTrackChart(String country, String metro, String start, String end, String apiKey) {
        return Chart.getChart("geo.getMetroHypeTrackChart", "track", StringUtilities.map("country", country, "metro", metro), start, end, -1, apiKey);
    }

    public static Chart<Artist> getMetroUniqueArtistChart(String country, String metro, String apiKey) {
        return Geo.getMetroUniqueArtistChart(country, metro, null, null, apiKey);
    }

    public static Chart<Artist> getMetroUniqueArtistChart(Metro metro, String start, String end, String apiKey) {
        return Geo.getMetroUniqueArtistChart(metro.getCountry(), metro.getName(), start, end, apiKey);
    }

    public static Chart<Artist> getMetroUniqueArtistChart(String country, String metro, String start, String end, String apiKey) {
        return Chart.getChart("geo.getMetroUniqueArtistChart", "artist", StringUtilities.map("country", country, "metro", metro), start, end, -1, apiKey);
    }

    public static Chart<Track> getMetroUniqueTrackChart(String country, String metro, String apiKey) {
        return Geo.getMetroUniqueTrackChart(country, metro, null, null, apiKey);
    }

    public static Chart<Track> getMetroUniqueTrackChart(Metro metro, String start, String end, String apiKey) {
        return Geo.getMetroUniqueTrackChart(metro.getCountry(), metro.getName(), start, end, apiKey);
    }

    public static Chart<Track> getMetroUniqueTrackChart(String country, String metro, String start, String end, String apiKey) {
        return Chart.getChart("geo.getMetroUniqueTrackChart", "track", StringUtilities.map("country", country, "metro", metro), start, end, -1, apiKey);
    }

    public static class Metro {
        private String name;
        private String country;

        public Metro(String name, String country) {
            this.name = name;
            this.country = country;
        }

        public String getName() {
            return this.name;
        }

        public String getCountry() {
            return this.country;
        }
    }
}

