/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Album;
import de.umass.lastfm.Artist;
import de.umass.lastfm.Caller;
import de.umass.lastfm.PaginatedResult;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Track;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    private Library() {
    }

    public static PaginatedResult<Artist> getArtists(String user, String apiKey) {
        return Library.getArtists(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Artist> getArtists(String user, int page, String apiKey) {
        return Library.getArtists(user, page, 0, apiKey);
    }

    public static PaginatedResult<Artist> getArtists(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        Result result = Caller.getInstance().call("library.getArtists", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Artist.class);
    }

    public static Collection<Artist> getAllArtists(String user, String apiKey) {
        int total;
        ArrayList<Artist> artists = null;
        int page = 1;
        do {
            PaginatedResult<Artist> result = Library.getArtists(user, page, apiKey);
            total = result.getTotalPages();
            Collection<Artist> pageResults = result.getPageResults();
            if (artists == null) {
                artists = new ArrayList<Artist>(total * pageResults.size());
            }
            artists.addAll(pageResults);
        } while (++page <= total);
        return artists;
    }

    public static PaginatedResult<Album> getAlbums(String user, String apiKey) {
        return Library.getAlbums(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Album> getAlbums(String user, int page, String apiKey) {
        return Library.getAlbums(user, page, 0, apiKey);
    }

    public static PaginatedResult<Album> getAlbums(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        Result result = Caller.getInstance().call("library.getAlbums", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Album.class);
    }

    public static Collection<Album> getAllAlbums(String user, String apiKey) {
        int total;
        ArrayList<Album> albums = null;
        int page = 1;
        do {
            PaginatedResult<Album> result = Library.getAlbums(user, page, apiKey);
            total = result.getTotalPages();
            Collection<Album> pageResults = result.getPageResults();
            if (albums == null) {
                albums = new ArrayList<Album>(total * pageResults.size());
            }
            albums.addAll(pageResults);
        } while (++page <= total);
        return albums;
    }

    public static PaginatedResult<Track> getTracks(String user, String apiKey) {
        return Library.getTracks(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Track> getTracks(String user, int page, String apiKey) {
        return Library.getTracks(user, page, 0, apiKey);
    }

    public static PaginatedResult<Track> getTracks(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        Result result = Caller.getInstance().call("library.getTracks", apiKey, params);
        return ResponseBuilder.buildPaginatedResult(result, Track.class);
    }

    public static Collection<Track> getAllTracks(String user, String apiKey) {
        int total;
        ArrayList<Track> tracks = null;
        int page = 1;
        do {
            PaginatedResult<Track> result = Library.getTracks(user, page, apiKey);
            total = result.getTotalPages();
            Collection<Track> pageResults = result.getPageResults();
            if (tracks == null) {
                tracks = new ArrayList<Track>(total * pageResults.size());
            }
            tracks.addAll(pageResults);
        } while (++page <= total);
        return tracks;
    }

    public static Result addArtist(String artist, Session session) {
        return Caller.getInstance().call("library.addArtist", session, "artist", artist);
    }

    public static Result addAlbum(String artist, String album, Session session) {
        return Caller.getInstance().call("library.addAlbum", session, "artist", artist, "album", album);
    }

    public static Result addTrack(String artist, String track, Session session) {
        return Caller.getInstance().call("library.addTrack", session, "artist", artist, "track", track);
    }

    public static Result removeArtist(String artist, Session session) {
        return Caller.getInstance().call("library.removeArtist", session, "artist", artist);
    }

    public static Result removeAlbum(String artist, String album, Session session) {
        return Caller.getInstance().call("library.removeAlbum", session, "artist", artist, "album", album);
    }

    public static Result removeTrack(String artist, String track, Session session) {
        return Caller.getInstance().call("library.removeTrack", session, "artist", artist, "track", track);
    }

    public static Result removeScrobble(String artist, String track, long timestamp, Session session) {
        return Caller.getInstance().call("library.removeScrobble", session, "artist", artist, "track", track, "timestamp", String.valueOf(timestamp));
    }
}

