/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.ImageHolder;
import de.umass.xml.DomElement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MusicEntry
extends ImageHolder {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZZ", Locale.ENGLISH);
    protected String name;
    protected String url;
    protected String mbid;
    protected int playcount;
    protected int userPlaycount;
    protected int listeners;
    protected boolean streamable;
    protected String id;
    protected int percentageChange;
    protected Collection<String> tags = new ArrayList<String>();
    private Date wikiLastChanged;
    private String wikiSummary;
    private String wikiText;
    private float similarityMatch;

    protected MusicEntry(String name, String url) {
        this(name, url, null, -1, -1, false);
    }

    protected MusicEntry(String name, String url, String mbid, int playcount, int listeners, boolean streamable) {
        this.name = name;
        this.url = url;
        this.mbid = mbid;
        this.playcount = playcount;
        this.listeners = listeners;
        this.streamable = streamable;
    }

    public int getListeners() {
        return this.listeners;
    }

    public String getMbid() {
        return this.mbid;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public int getPlaycount() {
        return this.playcount;
    }

    public int getUserPlaycount() {
        return this.userPlaycount;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public String getUrl() {
        return this.url;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public int getPercentageChange() {
        return this.percentageChange;
    }

    public Date getWikiLastChanged() {
        return this.wikiLastChanged;
    }

    public String getWikiSummary() {
        return this.wikiSummary;
    }

    public String getWikiText() {
        return this.wikiText;
    }

    public float getSimilarityMatch() {
        return this.similarityMatch;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", url='" + this.url + '\'' + ", mbid='" + this.mbid + '\'' + ", playcount=" + this.playcount + ", listeners=" + this.listeners + ", streamable=" + this.streamable + ']';
    }

    protected static void loadStandardInfo(MusicEntry entry, DomElement element) {
        DomElement wiki;
        String listenersString;
        String userPlaycountString;
        String playcountString;
        DomElement statsChild = element.getChild("stats");
        if (statsChild != null) {
            playcountString = statsChild.getChildText("playcount");
            userPlaycountString = statsChild.getChildText("userplaycount");
            listenersString = statsChild.getChildText("listeners");
        } else {
            playcountString = element.getChildText("playcount");
            userPlaycountString = element.getChildText("userplaycount");
            listenersString = element.getChildText("listeners");
        }
        if (element.hasChild("id")) {
            entry.id = element.getChildText("id");
        }
        if (element.hasChild("match")) {
            entry.similarityMatch = Float.parseFloat(element.getChildText("match"));
        }
        if (element.hasChild("percentagechange")) {
            entry.percentageChange = Integer.parseInt(element.getChildText("percentagechange"));
        }
        int playcount = playcountString == null || playcountString.length() == 0 ? -1 : Integer.parseInt(playcountString);
        int userPlaycount = userPlaycountString == null || userPlaycountString.length() == 0 ? -1 : Integer.parseInt(userPlaycountString);
        int listeners = listenersString == null || listenersString.length() == 0 ? -1 : Integer.parseInt(listenersString);
        String s = element.getChildText("streamable");
        boolean streamable = s != null && s.length() != 0 && Integer.parseInt(s) == 1;
        entry.name = element.getChildText("name");
        entry.url = element.getChildText("url");
        entry.mbid = element.getChildText("mbid");
        entry.playcount = playcount;
        entry.userPlaycount = userPlaycount;
        entry.listeners = listeners;
        entry.streamable = streamable;
        DomElement tags = element.getChild("tags");
        if (tags == null) {
            tags = element.getChild("toptags");
        }
        if (tags != null) {
            for (DomElement tage : tags.getChildren("tag")) {
                entry.tags.add(tage.getChildText("name"));
            }
        }
        if ((wiki = element.getChild("bio")) == null) {
            wiki = element.getChild("wiki");
        }
        if (wiki != null) {
            String publishedText = wiki.getChildText("published");
            try {
                entry.wikiLastChanged = DATE_FORMAT.parse(publishedText);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat clFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZZ", Locale.getDefault());
                    entry.wikiLastChanged = clFormat.parse(publishedText);
                }
                catch (ParseException e2) {
                    // empty catch block
                }
            }
            entry.wikiSummary = wiki.getChildText("summary");
            entry.wikiText = wiki.getChildText("content");
        }
        ImageHolder.loadImages(entry, element);
    }
}

