/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.lastfm.Caller;
import de.umass.lastfm.ImageSize;
import de.umass.lastfm.ItemFactory;
import de.umass.lastfm.ResponseBuilder;
import de.umass.lastfm.Result;
import de.umass.lastfm.Session;
import de.umass.lastfm.Track;
import de.umass.xml.DomElement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Playlist {
    static final ItemFactory<Playlist> FACTORY = new PlaylistFactory();
    private int id;
    private String title;
    private String annotation;
    private int size;
    private String creator;
    private List<Track> tracks = new ArrayList<Track>();

    private Playlist() {
    }

    public String getCreator() {
        return this.creator;
    }

    public int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public static Playlist fetchAlbumPlaylist(String albumId, String apiKey) {
        return Playlist.fetch("lastfm://playlist/album/" + albumId, apiKey);
    }

    public static Playlist fetchUserPlaylist(int playlistId, String apiKey) {
        return Playlist.fetch("lastfm://playlist/" + playlistId, apiKey);
    }

    public static Playlist fetchTagPlaylist(String tag, String apiKey) {
        return Playlist.fetch("lastfm://playlist/tag/" + tag + "/freetracks", apiKey);
    }

    public static Playlist fetch(String playlistUrl, String apiKey) {
        Result result = Caller.getInstance().call("playlist.fetch", apiKey, "playlistURL", playlistUrl);
        return ResponseBuilder.buildItem(result, Playlist.class);
    }

    public static Result addTrack(int playlistId, String artist, String track, Session session) {
        return Caller.getInstance().call("playlist.addTrack", session, "playlistID", String.valueOf(playlistId), "artist", artist, "track", track);
    }

    public static Playlist create(String title, String description, Session session) {
        Result result = Caller.getInstance().call("playlist.create", session, "title", title, "description", description);
        if (!result.isSuccessful()) {
            return null;
        }
        return ResponseBuilder.buildItem(result.getContentElement().getChild("playlist"), Playlist.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlaylistFactory
    implements ItemFactory<Playlist> {
        private PlaylistFactory() {
        }

        @Override
        public Playlist createItemFromElement(DomElement element) {
            Playlist playlist = new Playlist();
            if (element.hasChild("id")) {
                playlist.id = Integer.parseInt(element.getChildText("id"));
            }
            playlist.title = element.getChildText("title");
            if (element.hasChild("size")) {
                playlist.size = Integer.parseInt(element.getChildText("size"));
            }
            playlist.creator = element.getChildText("creator");
            playlist.annotation = element.getChildText("annotation");
            DomElement trackList = element.getChild("trackList");
            if (trackList != null) {
                for (DomElement te : trackList.getChildren("track")) {
                    Track t = new Track(te.getChildText("title"), te.getChildText("identifier"), te.getChildText("creator"));
                    t.album = te.getChildText("album");
                    t.duration = Integer.parseInt(te.getChildText("duration")) / 1000;
                    t.imageUrls.put(ImageSize.LARGE, te.getChildText("image"));
                    t.imageUrls.put(ImageSize.ORIGINAL, te.getChildText("image"));
                    t.location = te.getChildText("location");
                    for (DomElement ext : te.getChildren("extension")) {
                        if (!"http://www.last.fm".equals(ext.getAttribute("application"))) continue;
                        for (DomElement child : ext.getChildren()) {
                            t.lastFmExtensionInfos.put(child.getTagName(), child.getText());
                        }
                    }
                    playlist.tracks.add(t);
                }
                if (playlist.size == 0) {
                    playlist.size = playlist.tracks.size();
                }
            }
            return playlist;
        }
    }
}

