/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm;

import de.umass.xml.DomElement;
import org.w3c.dom.Document;

public class Result {
    protected Status status;
    protected String errorMessage = null;
    protected int errorCode = -1;
    protected int httpErrorCode = -1;
    protected Document resultDocument;

    protected Result(Document resultDocument) {
        this.status = Status.OK;
        this.resultDocument = resultDocument;
    }

    protected Result(String errorMessage) {
        this.status = Status.FAILED;
        this.errorMessage = errorMessage;
    }

    static Result createOkResult(Document resultDocument) {
        return new Result(resultDocument);
    }

    static Result createHttpErrorResult(int httpErrorCode, String errorMessage) {
        Result r = new Result(errorMessage);
        r.httpErrorCode = httpErrorCode;
        return r;
    }

    static Result createRestErrorResult(int errorCode, String errorMessage) {
        Result r = new Result(errorMessage);
        r.errorCode = errorCode;
        return r;
    }

    public boolean isSuccessful() {
        return this.status == Status.OK;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public Status getStatus() {
        return this.status;
    }

    public Document getResultDocument() {
        return this.resultDocument;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public DomElement getContentElement() {
        if (!this.isSuccessful()) {
            return null;
        }
        return new DomElement(this.resultDocument.getDocumentElement()).getChild("*");
    }

    public String toString() {
        return "Result[isSuccessful=" + this.isSuccessful() + ", errorCode=" + this.errorCode + ", httpErrorCode=" + this.httpErrorCode + ", errorMessage=" + this.errorMessage + ", status=" + (Object)((Object)this.status) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK,
        FAILED;

    }
}

