/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm.cache;

import de.umass.lastfm.cache.DefaultExpirationPolicy;
import de.umass.lastfm.cache.ExpirationPolicy;
import de.umass.util.StringUtilities;
import java.io.InputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cache {
    private static boolean hashCacheEntryNames = true;
    private ExpirationPolicy expirationPolicy = new DefaultExpirationPolicy();

    protected Cache() {
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        if (expirationPolicy == null) {
            throw new NullPointerException("policy == null");
        }
        this.expirationPolicy = expirationPolicy;
    }

    public abstract boolean contains(String var1);

    public abstract InputStream load(String var1);

    public abstract void remove(String var1);

    public abstract void store(String var1, InputStream var2, long var3);

    public abstract boolean isExpired(String var1);

    public abstract void clear();

    public final long findExpirationDate(String method, Map<String, String> params) {
        long expirationTime = this.getExpirationPolicy().getExpirationTime(method, params);
        long expirationDate = -1L;
        if (expirationTime > 0L) {
            expirationDate = expirationTime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + expirationTime;
        }
        return expirationDate;
    }

    public static String createCacheEntryName(String method, Map<String, String> params) {
        if (!(params instanceof SortedMap)) {
            params = new TreeMap<String, String>(params);
        }
        StringBuilder b = new StringBuilder(100);
        b.append(method.toLowerCase());
        b.append('.');
        for (Map.Entry<String, String> e : params.entrySet()) {
            b.append(e.getKey());
            b.append(e.getValue());
        }
        String name = b.toString();
        if (hashCacheEntryNames) {
            return StringUtilities.md5(name);
        }
        return StringUtilities.cleanUp(name);
    }

    public static void setHashCacheEntryNames(boolean hashCacheEntryNames) {
        Cache.hashCacheEntryNames = hashCacheEntryNames;
    }
}

