/*
 * Decompiled with CFR 0.152.
 */
package de.umass.lastfm.cache;

import de.umass.lastfm.cache.Cache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DatabaseCache
extends Cache {
    protected static final String DEFAULT_TABLE_NAME = "LASTFM_CACHE";
    protected String tableName;
    protected Connection connection;

    public DatabaseCache(Connection connection) throws SQLException {
        this(connection, DEFAULT_TABLE_NAME);
    }

    public DatabaseCache(Connection connection, String tableName) throws SQLException {
        this.connection = connection;
        this.tableName = tableName;
        ResultSet tables = this.connection.getMetaData().getTables(null, null, tableName, null);
        if (!tables.next()) {
            this.createTable();
        }
    }

    protected void createTable() throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("CREATE TABLE " + this.tableName + " (id VARCHAR(200) PRIMARY KEY, expiration_date TIMESTAMP, response TEXT)");
        stmt.execute();
        stmt.close();
    }

    public boolean contains(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT id FROM " + this.tableName + " WHERE id = ?");
            stmt.setString(1, cacheEntryName);
            ResultSet result = stmt.executeQuery();
            boolean b = result.next();
            stmt.close();
            return b;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public InputStream load(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT response FROM " + this.tableName + " WHERE id = ?");
            stmt.setString(1, cacheEntryName);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                String s = result.getString("response");
                stmt.close();
                return new ByteArrayInputStream(s.getBytes("UTF-8"));
            }
            stmt.close();
        }
        catch (SQLException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public void remove(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE id = ?");
            stmt.setString(1, cacheEntryName);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void store(String cacheEntryName, InputStream inputStream, long expirationDate) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO " + this.tableName + " (id, expiration_date, response) VALUES(?, ?, ?)");
            stmt.setString(1, cacheEntryName);
            stmt.setTimestamp(2, new Timestamp(expirationDate));
            stmt.setCharacterStream(3, (Reader)new InputStreamReader(inputStream, "UTF-8"), -1);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public boolean isExpired(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT expiration_date FROM " + this.tableName + " WHERE id = ?");
            stmt.setString(1, cacheEntryName);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                Timestamp timestamp = result.getTimestamp("expiration_date");
                long expirationDate = timestamp.getTime();
                stmt.close();
                return expirationDate < System.currentTimeMillis();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public void clear() {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM " + this.tableName);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

