/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import de.undercouch.bson4jackson.io.StaticBuffers;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DynamicOutputBuffer {
    public static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    protected static final StaticBuffers.Key BUFFER_KEY = StaticBuffers.Key.BUFFER2;
    public static final int DEFAULT_BUFFER_SIZE = Math.max(65536, 8192);
    protected final ByteOrder _order;
    protected final int _bufferSize;
    protected int _position;
    protected int _flushPosition;
    protected int _size;
    protected List<ByteBuffer> _buffers = new ArrayList<ByteBuffer>(1);
    protected Queue<ByteBuffer> _buffersToReuse;
    protected int _reuseBuffersCount = 0;

    public DynamicOutputBuffer() {
        this(DEFAULT_BYTE_ORDER);
    }

    public DynamicOutputBuffer(int initialSize) {
        this(DEFAULT_BYTE_ORDER, initialSize);
    }

    public DynamicOutputBuffer(ByteOrder order) {
        this(order, DEFAULT_BUFFER_SIZE);
    }

    public DynamicOutputBuffer(ByteOrder order, int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Initial buffer size must be larger than 0");
        }
        this._order = order;
        this._bufferSize = initialSize;
        this.clear();
    }

    public void setReuseBuffersCount(int count) {
        this._reuseBuffersCount = count;
        if (this._buffersToReuse != null) {
            if (this._reuseBuffersCount == 0) {
                this._buffersToReuse = null;
            } else {
                while (this._reuseBuffersCount < this._buffersToReuse.size()) {
                    this._buffersToReuse.poll();
                }
            }
        }
    }

    protected ByteBuffer allocateBuffer() {
        if (this._buffersToReuse != null && !this._buffersToReuse.isEmpty()) {
            ByteBuffer bb = this._buffersToReuse.poll();
            bb.rewind();
            bb.limit(bb.capacity());
            return bb;
        }
        ByteBuffer r = StaticBuffers.getInstance().byteBuffer(BUFFER_KEY, this._bufferSize);
        r.limit(this._bufferSize);
        return r.order(this._order);
    }

    protected void deallocateBuffer(int n) {
        ByteBuffer bb = this._buffers.set(n, null);
        if (bb != null && this._reuseBuffersCount > 0) {
            if (this._buffersToReuse == null) {
                this._buffersToReuse = new LinkedList<ByteBuffer>();
            }
            if (this._reuseBuffersCount > this._buffersToReuse.size()) {
                this._buffersToReuse.add(bb);
            }
        }
    }

    protected ByteBuffer addNewBuffer() {
        ByteBuffer bb = this.allocateBuffer();
        this._buffers.add(bb);
        return bb;
    }

    protected ByteBuffer getBuffer(int position) {
        int n = position / this._bufferSize;
        while (n >= this._buffers.size()) {
            this.addNewBuffer();
        }
        return this._buffers.get(n);
    }

    protected void adaptSize(int size) {
        if (size > this._size) {
            this._size = size;
        }
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        if (this._buffersToReuse != null && !this._buffersToReuse.isEmpty()) {
            StaticBuffers.getInstance().releaseByteBuffer(BUFFER_KEY, this._buffersToReuse.peek());
        } else if (!this._buffers.isEmpty()) {
            StaticBuffers.getInstance().releaseByteBuffer(BUFFER_KEY, this._buffers.get(0));
        }
        if (this._buffersToReuse != null) {
            this._buffersToReuse.clear();
        }
        this._buffers.clear();
        this._position = 0;
        this._flushPosition = 0;
        this._size = 0;
    }

    public void putByte(byte b) {
        this.putByte(this._position, b);
        ++this._position;
    }

    public void putBytes(byte ... bs) {
        this.putBytes(this._position, bs);
        this._position += bs.length;
    }

    public void putBytes(byte[] bs, int offset, int length) {
        this.putBytes(this._position, bs, offset, length);
        this._position += length;
    }

    public void putByte(int pos, byte b) {
        this.adaptSize(pos + 1);
        ByteBuffer bb = this.getBuffer(pos);
        int i = pos % this._bufferSize;
        bb.put(i, b);
    }

    public void putBytes(int pos, byte ... bs) {
        this.putBytes(pos, bs, 0, bs.length);
    }

    public void putBytes(int pos, byte[] bs, int offset, int length) {
        this.adaptSize(pos + length);
        while (length > 0) {
            ByteBuffer bb = this.getBuffer(pos);
            int index = pos % this._bufferSize;
            bb.position(index);
            int chunkLength = Math.min(bb.limit() - index, length);
            bb.put(bs, offset, chunkLength);
            pos += chunkLength;
            offset += chunkLength;
            length -= chunkLength;
        }
    }

    public void putInt(int i) {
        this.putInt(this._position, i);
        this._position += 4;
    }

    public void putInt(int pos, int i) {
        this.adaptSize(pos + 4);
        ByteBuffer bb = this.getBuffer(pos);
        int index = pos % this._bufferSize;
        if (bb.limit() - index >= 4) {
            bb.putInt(index, i);
        } else {
            byte b0 = (byte)i;
            byte b1 = (byte)(i >> 8);
            byte b2 = (byte)(i >> 16);
            byte b3 = (byte)(i >> 24);
            if (this._order == ByteOrder.BIG_ENDIAN) {
                this.putBytes(pos, b3, b2, b1, b0);
            } else {
                this.putBytes(pos, b0, b1, b2, b3);
            }
        }
    }

    public void putLong(long l) {
        this.putLong(this._position, l);
        this._position += 8;
    }

    public void putLong(int pos, long l) {
        this.adaptSize(pos + 8);
        ByteBuffer bb = this.getBuffer(pos);
        int index = pos % this._bufferSize;
        if (bb.limit() - index >= 8) {
            bb.putLong(index, l);
        } else {
            byte b0 = (byte)l;
            byte b1 = (byte)(l >> 8);
            byte b2 = (byte)(l >> 16);
            byte b3 = (byte)(l >> 24);
            byte b4 = (byte)(l >> 32);
            byte b5 = (byte)(l >> 40);
            byte b6 = (byte)(l >> 48);
            byte b7 = (byte)(l >> 56);
            if (this._order == ByteOrder.BIG_ENDIAN) {
                this.putBytes(pos, b7, b6, b5, b4, b3, b2, b1, b0);
            } else {
                this.putBytes(pos, b0, b1, b2, b3, b4, b5, b6, b7);
            }
        }
    }

    public void putFloat(float f) {
        this.putFloat(this._position, f);
        this._position += 4;
    }

    public void putFloat(int pos, float f) {
        this.putInt(pos, Float.floatToRawIntBits(f));
    }

    public void putDouble(double d) {
        this.putDouble(this._position, d);
        this._position += 8;
    }

    public void putDouble(int pos, double d) {
        this.putLong(pos, Double.doubleToRawLongBits(d));
    }

    public void putString(CharSequence s) {
        this.putString(this._position, s);
        this._position += s.length() * 2;
    }

    public void putString(int pos, CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            byte b0 = (byte)c;
            byte b1 = (byte)(c >> 8);
            if (this._order == ByteOrder.BIG_ENDIAN) {
                this.putBytes(pos, b1, b0);
            } else {
                this.putBytes(pos, b0, b1);
            }
            pos += 2;
        }
    }

    public int putUTF8(String s) {
        int written = this.putUTF8(this._position, s);
        this._position += written;
        return written;
    }

    public int putUTF8(int pos, String s) {
        char c;
        int si;
        int pos2 = pos;
        ByteBuffer bb = this.getBuffer(pos2);
        byte[] arr = bb.array();
        int index = pos2 % this._bufferSize;
        for (si = 0; si < s.length() && index < bb.limit() && (c = s.charAt(si)) <= '\u007f'; ++si) {
            arr[index++] = (byte)c;
            ++pos2;
        }
        while (si < s.length()) {
            if (index == bb.limit()) {
                bb.position(index);
                bb = this.getBuffer(pos2);
                arr = bb.array();
                index = 0;
            }
            if ((c = s.charAt(si)) <= '\u007f') {
                arr[index++] = (byte)c;
                ++pos2;
            } else if (c <= '\u07ff') {
                arr[index++] = (byte)(0xC0 | c >> 6);
                ++pos2;
                if (index == bb.limit()) {
                    bb.position(index);
                    bb = this.getBuffer(pos2);
                    arr = bb.array();
                    index = 0;
                }
                arr[index++] = (byte)(0x80 | c & 0x3F);
                ++pos2;
            } else {
                if (Character.isLowSurrogate(c)) {
                    throw new IllegalStateException("Could not encode string. Unexpected low surrogate code unit at position " + si);
                }
                if (Character.isHighSurrogate(c)) {
                    if (si + 1 >= s.length()) {
                        throw new IllegalStateException("Could not encode string. Missing low surrogate code unit at end of input.");
                    }
                    char d = s.charAt(si + 1);
                    if (!Character.isLowSurrogate(d)) {
                        throw new IllegalStateException("Could not encode string. Missing low surrogate code unit at position " + si);
                    }
                    ++si;
                    int cp = Character.toCodePoint(c, d);
                    arr[index++] = (byte)(0xF0 | cp >> 18);
                    ++pos2;
                    if (index == bb.limit()) {
                        bb.position(index);
                        bb = this.getBuffer(pos2);
                        arr = bb.array();
                        index = 0;
                    }
                    arr[index++] = (byte)(0x80 | cp >> 12 & 0x3F);
                    ++pos2;
                    if (index == bb.limit()) {
                        bb.position(index);
                        bb = this.getBuffer(pos2);
                        arr = bb.array();
                        index = 0;
                    }
                    arr[index++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    ++pos2;
                    if (index == bb.limit()) {
                        bb.position(index);
                        bb = this.getBuffer(pos2);
                        arr = bb.array();
                        index = 0;
                    }
                    arr[index++] = (byte)(0x80 | cp & 0x3F);
                    ++pos2;
                } else {
                    arr[index++] = (byte)(0xE0 | c >> 12);
                    ++pos2;
                    if (index == bb.limit()) {
                        bb.position(index);
                        bb = this.getBuffer(pos2);
                        arr = bb.array();
                        index = 0;
                    }
                    arr[index++] = (byte)(0x80 | c >> 6 & 0x3F);
                    ++pos2;
                    if (index == bb.limit()) {
                        bb.position(index);
                        bb = this.getBuffer(pos2);
                        arr = bb.array();
                        index = 0;
                    }
                    arr[index++] = (byte)(0x80 | c & 0x3F);
                    ++pos2;
                }
            }
            ++si;
        }
        bb.position(index);
        this.adaptSize(pos2);
        return pos2 - pos;
    }

    public void flushTo(OutputStream out) throws IOException {
        int n1 = this._flushPosition / this._bufferSize;
        int n2 = this._position / this._bufferSize;
        if (n1 < n2) {
            this.flushTo(Channels.newChannel(out));
        }
    }

    public void flushTo(WritableByteChannel out) throws IOException {
        int n2 = this._position / this._bufferSize;
        for (int n1 = this._flushPosition / this._bufferSize; n1 < n2; ++n1) {
            ByteBuffer bb = this._buffers.get(n1);
            bb.rewind();
            out.write(bb);
            this.deallocateBuffer(n1);
            this._flushPosition += this._bufferSize;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writeTo(Channels.newChannel(out));
    }

    public void writeTo(WritableByteChannel out) throws IOException {
        int n1 = this._flushPosition / this._bufferSize;
        int n2 = this._buffers.size();
        int toWrite = this._size - this._flushPosition;
        while (n1 < n2) {
            int curWrite = Math.min(toWrite, this._bufferSize);
            ByteBuffer bb = this._buffers.get(n1);
            bb.position(curWrite);
            bb.flip();
            out.write(bb);
            ++n1;
            toWrite -= curWrite;
        }
    }
}

